/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import com.trilead.ssh2.Session;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ssh.SSHData;
import org.apache.hop.pipeline.transforms.ssh.SSHMeta;
import org.apache.hop.pipeline.transforms.ssh.SessionResult;

public class SSH
extends BaseTransform<SSHMeta, SSHData>
implements ITransform<SSHMeta, SSHData> {
    private static final Class<?> PKG = SSHMeta.class;

    public SSH(TransformMeta transformMeta, SSHMeta meta, SSHData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow() throws HopException {
        IRowMeta imeta;
        Object[] row;
        if (((SSHMeta)this.meta).isDynamicCommand()) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((SSHData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((SSHData)this.data).nrInputFields = ((SSHData)this.data).outputRowMeta.size();
                ((SSHMeta)this.meta).getFields(((SSHData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((SSHData)this.data).nrOutputFields = ((SSHData)this.data).outputRowMeta.size();
                if (((SSHMeta)this.meta).isDynamicCommand()) {
                    if (Utils.isEmpty((CharSequence)((SSHMeta)this.meta).getcommandfieldname())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"SSH.Error.CommandFieldMissing", (String[])new String[0]));
                    }
                    ((SSHData)this.data).indexOfCommand = ((SSHData)this.data).outputRowMeta.indexOfValue(((SSHMeta)this.meta).getcommandfieldname());
                    if (((SSHData)this.data).indexOfCommand < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"SSH.Exception.CouldnotFindField", (String[])new String[]{((SSHMeta)this.meta).getcommandfieldname()}));
                    }
                }
            }
        } else if (!((SSHData)this.data).wroteOneRow) {
            row = new Object[]{};
            this.incrementLinesRead();
            ((SSHData)this.data).wroteOneRow = true;
            if (this.first) {
                this.first = false;
                ((SSHData)this.data).outputRowMeta = new RowMeta();
                ((SSHData)this.data).nrInputFields = 0;
                ((SSHMeta)this.meta).getFields(((SSHData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((SSHData)this.data).nrOutputFields = ((SSHData)this.data).outputRowMeta.size();
                ((SSHData)this.data).commands = this.resolve(((SSHMeta)this.meta).getCommand());
            }
        } else {
            this.setOutputDone();
            return false;
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        Object[] rowData = new Object[((SSHData)this.data).nrOutputFields];
        for (int i = 0; i < ((SSHData)this.data).nrInputFields; ++i) {
            rowData[i] = row[i];
        }
        int index = ((SSHData)this.data).nrInputFields;
        Session session = null;
        try {
            if (((SSHMeta)this.meta).isDynamicCommand()) {
                ((SSHData)this.data).commands = ((SSHData)this.data).outputRowMeta.getString(row, ((SSHData)this.data).indexOfCommand);
                if (Utils.isEmpty((CharSequence)((SSHData)this.data).commands)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SSH.Error.MessageEmpty", (String[])new String[0]));
                }
            }
            session = ((SSHData)this.data).conn.openSession();
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.SessionOpened", (String[])new String[0]));
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SSH.Log.RunningCommand", (String[])new String[]{((SSHData)this.data).commands}));
            }
            session.execCommand(((SSHData)this.data).commands);
            SessionResult sessionresult = new SessionResult(session);
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.CommandRunnedCommand", (String[])new String[]{((SSHData)this.data).commands, sessionresult.getStdOut(), sessionresult.getStdErr()}));
            }
            rowData[index++] = sessionresult.getStd();
            if (!Utils.isEmpty((CharSequence)((SSHData)this.data).stdTypeField)) {
                rowData[index++] = sessionresult.isStdTypeErr();
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SSH.Log.OutputLine", (String[])new String[]{((SSHData)this.data).outputRowMeta.getString(rowData)}));
            }
            this.putRow(((SSHData)this.data).outputRowMeta, rowData);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SSH.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                boolean bl = false;
                return bl;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "SSH001");
            }
        }
        finally {
            if (session != null) {
                session.close();
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.SessionClosed", (String[])new String[0]));
                }
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            String servername = this.resolve(((SSHMeta)this.meta).getServerName());
            int nrPort = Const.toInt((String)this.resolve(((SSHMeta)this.meta).getPort()), (int)22);
            String username = this.resolve(((SSHMeta)this.meta).getuserName());
            String password = Utils.resolvePassword((IVariables)this.variables, (String)((SSHMeta)this.meta).getpassword());
            String keyFilename = this.resolve(((SSHMeta)this.meta).getKeyFileName());
            String passphrase = this.resolve(((SSHMeta)this.meta).getPassphrase());
            int timeOut = Const.toInt((String)this.resolve(((SSHMeta)this.meta).getTimeOut()), (int)0);
            String proxyhost = this.resolve(((SSHMeta)this.meta).getProxyHost());
            int proxyport = Const.toInt((String)this.resolve(((SSHMeta)this.meta).getProxyPort()), (int)0);
            String proxyusername = this.resolve(((SSHMeta)this.meta).getProxyUsername());
            String proxypassword = this.resolve(((SSHMeta)this.meta).getProxyPassword());
            if (Utils.isEmpty((CharSequence)servername)) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.MissingServerName", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)((SSHMeta)this.meta).getuserName())) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.UserNamedMissing", (String[])new String[0]));
                return false;
            }
            ((SSHData)this.data).stdOutField = this.resolve(((SSHMeta)this.meta).getStdOutFieldName());
            if (Utils.isEmpty((CharSequence)((SSHData)this.data).stdOutField)) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.StdOutFieldNameMissing", (String[])new String[0]));
                return false;
            }
            ((SSHData)this.data).stdTypeField = this.resolve(((SSHMeta)this.meta).getStdErrFieldName());
            try {
                ((SSHData)this.data).conn = SSHData.OpenConnection(servername, nrPort, username, password, ((SSHMeta)this.meta).isusePrivateKey(), keyFilename, passphrase, timeOut, (IVariables)this, proxyhost, proxyport, proxyusername, proxypassword);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.ConnectionOpened", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.OpeningConnection", (String[])new String[]{e.getMessage()}));
                return false;
            }
            return true;
        }
        return false;
    }
}

