/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databasejoin;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoin;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoinData;
import org.w3c.dom.Node;

@Transform(id="DBJoin", image="dbjoin.svg", name="i18n::BaseTransform.TypeLongDesc.DatabaseJoin", description="i18n::BaseTransform.TypeTooltipDesc.DatabaseJoin", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", documentationUrl="/pipeline/transforms/databasejoin.html")
public class DatabaseJoinMeta
extends BaseTransformMeta
implements ITransformMeta<DatabaseJoin, DatabaseJoinData> {
    private static final Class<?> PKG = DatabaseJoinMeta.class;
    private DatabaseMeta databaseMeta;
    private String sql;
    private int rowLimit;
    private boolean outerJoin;
    private String[] parameterField;
    private int[] parameterType;
    private boolean replacevars;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public boolean isVariableReplace() {
        return this.replacevars;
    }

    public void setVariableReplace(boolean replacevars) {
        this.replacevars = replacevars;
    }

    public String[] getParameterField() {
        return this.parameterField;
    }

    public void setParameterField(String[] parameterField) {
        this.parameterField = parameterField;
    }

    public int[] getParameterType() {
        return this.parameterType;
    }

    public void setParameterType(int[] parameterType) {
        this.parameterType = parameterType;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.parameterField = null;
        this.parameterType = null;
        this.outerJoin = false;
        this.replacevars = false;
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrparam) {
        this.parameterField = new String[nrparam];
        this.parameterType = new int[nrparam];
    }

    public Object clone() {
        DatabaseJoinMeta retval = (DatabaseJoinMeta)((Object)super.clone());
        int nrparam = this.parameterField.length;
        retval.allocate(nrparam);
        System.arraycopy(this.parameterField, 0, retval.parameterField, 0, nrparam);
        System.arraycopy(this.parameterType, 0, retval.parameterType, 0, nrparam);
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            this.sql = XmlHandler.getTagValue((Node)transformNode, (String)"sql");
            this.outerJoin = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"outer_join"));
            this.replacevars = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"replace_vars"));
            this.rowLimit = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"rowlimit"), (int)0);
            Node param = XmlHandler.getSubNode((Node)transformNode, (String)"parameter");
            int nrparam = XmlHandler.countNodes((Node)param, (String)"field");
            this.allocate(nrparam);
            for (int i = 0; i < nrparam; ++i) {
                Node pnode = XmlHandler.getSubNodeByNr((Node)param, (String)"field", (int)i);
                this.parameterField[i] = XmlHandler.getTagValue((Node)pnode, (String)"name");
                String ptype = XmlHandler.getTagValue((Node)pnode, (String)"type");
                this.parameterType[i] = ValueMetaFactory.getIdForValueMeta((String)ptype);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.rowLimit = 0;
        this.sql = "";
        this.outerJoin = false;
        this.parameterField = null;
        this.parameterType = null;
        this.outerJoin = false;
        this.replacevars = false;
        int nrparam = 0;
        this.allocate(nrparam);
        for (int i = 0; i < nrparam; ++i) {
            this.parameterField[i] = "param" + i;
            this.parameterType[i] = 1;
        }
    }

    public IRowMeta getParameterRow(IRowMeta fields) {
        RowMeta param = new RowMeta();
        if (fields != null) {
            for (int i = 0; i < this.parameterField.length; ++i) {
                IValueMeta v = fields.searchValueMeta(this.parameterField[i]);
                if (v == null) continue;
                param.addValueMeta(v);
            }
        }
        return param;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.databaseMeta == null) {
            return;
        }
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        this.databases = new Database[]{db};
        IRowMeta param = this.getParameterRow(row);
        IRowMeta add = null;
        try {
            add = db.getQueryFields(variables.resolve(this.sql), true, param, new Object[param.size()]);
        }
        catch (HopDatabaseException dbe) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.UnableToDetermineQueryFields", (String[])new String[0]) + Const.CR + this.sql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                IValueMeta v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(variables.resolve(this.sql), true, param, new Object[param.size()]);
                for (int i = 0; i < add.size(); ++i) {
                    IValueMeta v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                row.addRowMeta(add);
                db.disconnect();
            }
            catch (HopDatabaseException dbe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Exception.ErrorObtainingFields", (String[])new String[0]), (Throwable)dbe);
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rowlimit", (int)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    ").append(XmlHandler.addTagValue((String)"outer_join", (boolean)this.outerJoin));
        retval.append("    ").append(XmlHandler.addTagValue((String)"replace_vars", (boolean)this.replacevars));
        retval.append("    <parameter>").append(Const.CR);
        for (int i = 0; i < this.parameterField.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.parameterField[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.parameterType[i])));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </parameter>").append(Const.CR);
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.sql != null && this.sql.length() != 0) {
                    IRowMeta param = this.getParameterRow(prev);
                    errorMessage = "";
                    IRowMeta r = db.getQueryFields(variables.resolve(this.sql), true, param, new Object[param.size()]);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.QueryOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.InvalidDBQuery", (String[])new String[0]);
                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                    int q = db.countParameters(variables.resolve(this.sql));
                    if (q != this.parameterField.length) {
                        errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion", (String[])new String[0]) + Const.CR;
                        errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion2", (String[])new String[0]) + q + Const.CR;
                        errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.DismatchBetweenParametersAndQuestion3", (String[])new String[0]) + this.parameterField.length;
                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.NumberOfParamCorrect", (String[])new String[0]) + q + ")", (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    boolean first = true;
                    errorMessage = "";
                    boolean errorFound = false;
                    for (int i = 0; i < this.parameterField.length; ++i) {
                        IValueMeta v = prev.searchValueMeta(this.parameterField[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.MissingFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = errorMessage + "\t\t" + this.parameterField[i] + Const.CR;
                    }
                    cr = errorFound ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.CounldNotReadFields", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.ReceivingInfo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowMeta getTableFields(IVariables variables) {
        RowMeta param = new RowMeta();
        for (int i = 0; i < this.parameterField.length; ++i) {
            IValueMeta v;
            try {
                v = ValueMetaFactory.createValueMeta((String)this.parameterField[i], (int)this.parameterType[i]);
            }
            catch (HopPluginException e) {
                v = new ValueMetaNone(this.parameterField[i]);
            }
            param.addValueMeta(v);
        }
        IRowMeta fields = null;
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                fields = db.getQueryFields(variables.resolve(this.sql), true, (IRowMeta)param, new Object[param.size()]);
            }
            catch (HopDatabaseException dbe) {
                this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.Log.DatabaseErrorOccurred", (String[])new String[0]) + dbe.getMessage());
            }
            finally {
                db.disconnect();
            }
        }
        return fields;
    }

    public DatabaseJoin createTransform(TransformMeta transformMeta, DatabaseJoinData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new DatabaseJoin(transformMeta, this, data, cnr, tr, pipeline);
    }

    public DatabaseJoinData getTransformData() {
        return new DatabaseJoinData();
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        IRowMeta out = prev.clone();
        this.getFields(out, transformMeta.getName(), new IRowMeta[]{info}, null, variables, metadataProvider);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                IValueMeta outvalue = out.getValueMeta(i);
                DatabaseImpact di = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), transformMeta.getName(), variables.resolve(this.sql), BaseMessages.getString(PKG, (String)"DatabaseJoinMeta.DatabaseImpact.Title", (String[])new String[0]));
                impact.add(di);
            }
        }
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

