/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databasejoin;

import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoinData;
import org.apache.hop.pipeline.transforms.databasejoin.DatabaseJoinMeta;

public class DatabaseJoin
extends BaseTransform<DatabaseJoinMeta, DatabaseJoinData>
implements ITransform<DatabaseJoinMeta, DatabaseJoinData> {
    private static final Class<?> PKG = DatabaseJoinMeta.class;

    public DatabaseJoin(TransformMeta transformMeta, DatabaseJoinMeta meta, DatabaseJoinData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private synchronized void lookupValues(IRowMeta rowMeta, Object[] rowData) throws HopException {
        int i;
        int newIndex;
        Object[] newRow;
        if (this.first) {
            this.first = false;
            ((DatabaseJoinData)this.data).outputRowMeta = rowMeta.clone();
            ((DatabaseJoinMeta)this.meta).getFields(((DatabaseJoinData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{((DatabaseJoinMeta)this.meta).getTableFields((IVariables)this)}, null, (IVariables)this, this.metadataProvider);
            ((DatabaseJoinData)this.data).lookupRowMeta = new RowMeta();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.CheckingRow", (String[])new String[0]) + rowMeta.getString(rowData));
            }
            ((DatabaseJoinData)this.data).keynrs = new int[((DatabaseJoinMeta)this.meta).getParameterField().length];
            for (int i2 = 0; i2 < ((DatabaseJoinMeta)this.meta).getParameterField().length; ++i2) {
                ((DatabaseJoinData)this.data).keynrs[i2] = rowMeta.indexOfValue(((DatabaseJoinMeta)this.meta).getParameterField()[i2]);
                if (((DatabaseJoinData)this.data).keynrs[i2] < 0) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"DatabaseJoin.Exception.FieldNotFound", (String[])new String[]{((DatabaseJoinMeta)this.meta).getParameterField()[i2]}));
                }
                ((DatabaseJoinData)this.data).lookupRowMeta.addValueMeta(rowMeta.getValueMeta(((DatabaseJoinData)this.data).keynrs[i2]).clone());
            }
        }
        Object[] lookupRowData = new Object[((DatabaseJoinData)this.data).lookupRowMeta.size()];
        for (int i3 = 0; i3 < ((DatabaseJoinData)this.data).keynrs.length; ++i3) {
            lookupRowData[i3] = rowData[((DatabaseJoinData)this.data).keynrs[i3]];
        }
        ResultSet rs = ((DatabaseJoinData)this.data).db.openQuery(((DatabaseJoinData)this.data).pstmt, ((DatabaseJoinData)this.data).lookupRowMeta, lookupRowData);
        Object[] add = ((DatabaseJoinData)this.data).db.getRow(rs);
        IRowMeta addMeta = ((DatabaseJoinData)this.data).db.getReturnRowMeta();
        this.incrementLinesInput();
        int counter = 0;
        while (add != null && (((DatabaseJoinMeta)this.meta).getRowLimit() == 0 || counter < ((DatabaseJoinMeta)this.meta).getRowLimit())) {
            ++counter;
            newRow = RowDataUtil.resizeArray((Object[])rowData, (int)((DatabaseJoinData)this.data).outputRowMeta.size());
            newIndex = rowMeta.size();
            for (i = 0; i < addMeta.size(); ++i) {
                newRow[newIndex++] = add[i];
            }
            this.putRow(((DatabaseJoinData)this.data).outputRowMeta, ((DatabaseJoinData)this.data).outputRowMeta.cloneRow(newRow));
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.PutoutRow", (String[])new String[0]) + ((DatabaseJoinData)this.data).outputRowMeta.getString(newRow));
            }
            if (((DatabaseJoinMeta)this.meta).getRowLimit() != 0 && counter >= ((DatabaseJoinMeta)this.meta).getRowLimit()) continue;
            add = ((DatabaseJoinData)this.data).db.getRow(rs);
            this.incrementLinesInput();
        }
        if (counter == 0 && ((DatabaseJoinMeta)this.meta).isOuterJoin()) {
            if (((DatabaseJoinData)this.data).notfound == null) {
                ((DatabaseJoinData)this.data).notfound = new Object[((DatabaseJoinData)this.data).db.getReturnRowMeta().size()];
            }
            newRow = RowDataUtil.resizeArray((Object[])rowData, (int)((DatabaseJoinData)this.data).outputRowMeta.size());
            newIndex = rowMeta.size();
            for (i = 0; i < ((DatabaseJoinData)this.data).notfound.length; ++i) {
                newRow[newIndex++] = ((DatabaseJoinData)this.data).notfound[i];
            }
            this.putRow(((DatabaseJoinData)this.data).outputRowMeta, newRow);
        }
        ((DatabaseJoinData)this.data).db.closeQuery(rs);
    }

    public boolean processRow() throws HopException {
        block5: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage(), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block5;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DBJOIN001");
            }
        }
        return true;
    }

    public synchronized void stopRunning() throws HopException {
        if (this.isStopped() || ((DatabaseJoinData)this.data).isDisposed()) {
            return;
        }
        if (((DatabaseJoinData)this.data).db != null && ((DatabaseJoinData)this.data).db.getConnection() != null && !((DatabaseJoinData)this.data).isCanceled) {
            ((DatabaseJoinData)this.data).db.cancelStatement((Statement)((DatabaseJoinData)this.data).pstmt);
            this.setStopped(true);
            ((DatabaseJoinData)this.data).isCanceled = true;
        }
    }

    public boolean init() {
        block7: {
            if (super.init()) {
                if (((DatabaseJoinMeta)this.meta).getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((DatabaseJoinData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((DatabaseJoinMeta)this.meta).getDatabaseMeta());
                try {
                    ((DatabaseJoinData)this.data).db.connect();
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    String sql = ((DatabaseJoinMeta)this.meta).getSql();
                    if (((DatabaseJoinMeta)this.meta).isVariableReplace()) {
                        sql = this.resolve(sql);
                    }
                    ((DatabaseJoinData)this.data).pstmt = ((DatabaseJoinData)this.data).db.prepareSql(sql);
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.SQLStatement", (String[])new String[]{sql}));
                    }
                    ((DatabaseJoinData)this.data).db.setQueryLimit(((DatabaseJoinMeta)this.meta).getRowLimit());
                    return true;
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DatabaseJoin.Log.DatabaseError", (String[])new String[0]) + e.getMessage(), e);
                    if (((DatabaseJoinData)this.data).db == null) break block7;
                    ((DatabaseJoinData)this.data).db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (((DatabaseJoinData)this.data).db != null) {
            ((DatabaseJoinData)this.data).db.disconnect();
        }
        super.dispose();
    }
}

