/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.setvariables;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopWorkflowException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="SET_VARIABLES", name="i18n::ActionSetVariables.Name", description="i18n::ActionSetVariables.Description", image="SetVariables.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", documentationUrl="/workflow/actions/setvariables.html")
public class ActionSetVariables
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSetVariables.class;
    public boolean replaceVars = true;
    public String[] variableName = null;
    public String[] variableValue = null;
    public int[] variableType;
    public String filename;
    public int fileVariableType;
    public static final int VARIABLE_TYPE_JVM = 0;
    public static final int VARIABLE_TYPE_CURRENT_WORKFLOW = 1;
    public static final int VARIABLE_TYPE_PARENT_WORKFLOW = 2;
    public static final int VARIABLE_TYPE_ROOT_WORKFLOW = 3;
    public static final String[] variableTypeCode = new String[]{"JVM", "CURRENT_WORKFLOW", "PARENT_WORKFLOW", "ROOT_WORKFLOW"};
    private static final String[] variableTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.JVM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.CurrentWorkflow", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.ParentWorkflow", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSetVariables.VariableType.RootWorkflow", (String[])new String[0])};

    public ActionSetVariables(String n) {
        super(n, "");
    }

    public ActionSetVariables() {
        this("");
    }

    public void allocate(int nrFields) {
        this.variableName = new String[nrFields];
        this.variableValue = new String[nrFields];
        this.variableType = new int[nrFields];
    }

    public Object clone() {
        ActionSetVariables je = (ActionSetVariables)super.clone();
        if (this.variableName != null) {
            int nrFields = this.variableName.length;
            je.allocate(nrFields);
            System.arraycopy(this.variableName, 0, je.variableName, 0, nrFields);
            System.arraycopy(this.variableValue, 0, je.variableValue, 0, nrFields);
            System.arraycopy(this.variableType, 0, je.variableType, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"replacevars", (boolean)this.replaceVars));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"file_variable_type", (String)ActionSetVariables.getVariableTypeCode(this.fileVariableType)));
        retval.append("      <fields>").append(Const.CR);
        if (this.variableName != null) {
            for (int i = 0; i < this.variableName.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"variable_name", (String)this.variableName[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"variable_value", (String)this.variableValue[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"variable_type", (String)ActionSetVariables.getVariableTypeCode(this.variableType[i])));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.replaceVars = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"replacevars"));
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.fileVariableType = ActionSetVariables.getVariableType(XmlHandler.getTagValue((Node)entrynode, (String)"file_variable_type"));
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.variableName[i] = XmlHandler.getTagValue((Node)fnode, (String)"variable_name");
                this.variableValue[i] = XmlHandler.getTagValue((Node)fnode, (String)"variable_value");
                this.variableType[i] = ActionSetVariables.getVariableType(XmlHandler.getTagValue((Node)fnode, (String)"variable_type"));
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Meta.UnableLoadXML", (String[])new String[]{xe.getMessage()}), (Throwable)xe);
        }
    }

    public Result execute(Result result, int nr) throws HopException {
        result.setResult(true);
        result.setNrErrors(0L);
        try {
            ArrayList<String> variables = new ArrayList<String>();
            ArrayList<String> variableValues = new ArrayList<String>();
            ArrayList<Integer> variableTypes = new ArrayList<Integer>();
            String realFilename = this.resolve(this.filename);
            if (!Utils.isEmpty((CharSequence)realFilename)) {
                try (InputStream is = HopVfs.getInputStream((String)realFilename);
                     InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                     BufferedReader reader = new BufferedReader(isr);){
                    Properties properties = new Properties();
                    properties.load(reader);
                    for (Object key : properties.keySet()) {
                        variables.add((String)key);
                        variableValues.add((String)properties.get(key));
                        variableTypes.add(this.fileVariableType);
                    }
                }
                catch (Exception e) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableReadPropertiesFile", (String[])new String[]{realFilename}));
                }
            }
            if (this.variableName != null) {
                for (int i = 0; i < this.variableName.length; ++i) {
                    variables.add(this.variableName[i]);
                    variableValues.add(this.variableValue[i]);
                    variableTypes.add(this.variableType[i]);
                }
            }
            if (this.parentWorkflow != null) {
                for (String key : this.getEntryTransformSetVariablesMap().keySet()) {
                    String parameterValue = this.parentWorkflow.getParameterValue(key);
                    if (parameterValue == null) {
                        this.parentWorkflow.setVariable(key, "");
                        this.setVariable(key, "");
                        continue;
                    }
                    this.parentWorkflow.setVariable(key, this.getEntryTransformSetVariable(key));
                    this.setVariable(key, this.getEntryTransformSetVariable(key));
                }
            }
            for (int i = 0; i < variables.size(); ++i) {
                String varname = (String)variables.get(i);
                String value = (String)variableValues.get(i);
                int type = (Integer)variableTypes.get(i);
                if (this.replaceVars) {
                    varname = this.resolve(varname);
                    value = this.resolve(value);
                }
                switch (type) {
                    case 0: {
                        if (value != null) {
                            System.setProperty(varname, value);
                        } else {
                            System.clearProperty(varname);
                        }
                        this.setVariable(varname, value);
                        for (IWorkflowEngine parentWorkflowTraverse = this.parentWorkflow; parentWorkflowTraverse != null; parentWorkflowTraverse = parentWorkflowTraverse.getParentWorkflow()) {
                            parentWorkflowTraverse.setVariable(varname, value);
                        }
                        break;
                    }
                    case 3: {
                        this.setVariable(varname, value);
                        for (IWorkflowEngine rootWorkflow = this.parentWorkflow; rootWorkflow != null; rootWorkflow = rootWorkflow.getParentWorkflow()) {
                            rootWorkflow.setVariable(varname, value);
                        }
                        break;
                    }
                    case 1: {
                        this.setVariable(varname, value);
                        if (this.parentWorkflow != null) {
                            String parameterValue = this.parentWorkflow.getParameterValue(varname);
                            if (parameterValue == null) {
                                this.setEntryTransformSetVariable(varname, value);
                            } else if (parameterValue != null && parameterValue != value && !this.entryTransformSetVariablesMap.containsKey(varname)) {
                                this.setEntryTransformSetVariable(varname, parameterValue);
                            }
                            this.parentWorkflow.setVariable(varname, value);
                            break;
                        }
                        throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableSetVariableCurrentWorkflow", (String[])new String[]{varname}));
                    }
                    case 2: {
                        this.setVariable(varname, value);
                        if (this.parentWorkflow != null) {
                            this.parentWorkflow.setVariable(varname, value);
                            IWorkflowEngine gpWorkflow = this.parentWorkflow.getParentWorkflow();
                            if (gpWorkflow != null) {
                                gpWorkflow.setVariable(varname, value);
                                break;
                            }
                            throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableSetVariableParentWorkflow", (String[])new String[]{varname}));
                        }
                        throw new HopWorkflowException(BaseMessages.getString(PKG, (String)"ActionSetVariables.Error.UnableSetVariableCurrentWorkflow", (String[])new String[]{varname}));
                    }
                }
                if (!this.log.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSetVariables.Log.SetVariableToValue", (String[])new String[]{varname, value}));
            }
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"ActionSetVariables.UnExcpectedError", (String[])new String[]{e.getMessage()}));
        }
        return result;
    }

    public void setReplaceVars(boolean replaceVars) {
        this.replaceVars = replaceVars;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isReplaceVars() {
        return this.replaceVars;
    }

    public String[] getVariableValue() {
        return this.variableValue;
    }

    public void setVariableName(String[] fieldValue) {
        this.variableName = fieldValue;
    }

    public int[] getVariableType() {
        return this.variableType;
    }

    public static final String getVariableTypeCode(int variableType) {
        return variableTypeCode[variableType];
    }

    public static final String getVariableTypeDescription(int variableType) {
        return variableTypeDesc[variableType];
    }

    public static final int getVariableType(String variableType) {
        int i;
        for (i = 0; i < variableTypeCode.length; ++i) {
            if (!variableTypeCode[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        for (i = 0; i < variableTypeDesc.length; ++i) {
            if (!variableTypeDesc[i].equalsIgnoreCase(variableType)) continue;
            return i;
        }
        return 0;
    }

    public void setVariableType(int[] localVariable) {
        this.variableType = localVariable;
    }

    public static final String[] getVariableTypeDescriptions() {
        return variableTypeDesc;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "variableName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.variableName.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "variableName[" + i + "]", remarks, ctx);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.variableName != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.variableName.length; ++i) {
                String filename = this.resolve(this.variableName[i]);
                if (reference == null) {
                    reference = new ResourceReference((IResourceHolder)this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getFileVariableType() {
        return this.fileVariableType;
    }

    public void setFileVariableType(int fileVariableType) {
        this.fileVariableType = fileVariableType;
    }
}

