/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class TimestampedValue<V> {
    private final @Nullable V value;
    private final Instant timestamp;

    public static <V> TimestampedValue<V> atMinimumTimestamp(@Nullable V value) {
        return TimestampedValue.of(value, BoundedWindow.TIMESTAMP_MIN_VALUE);
    }

    public static <V> TimestampedValue<V> of(@Nullable V value, Instant timestamp) {
        return new TimestampedValue<V>(value, timestamp);
    }

    public V getValue() {
        return this.value;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof TimestampedValue)) {
            return false;
        }
        TimestampedValue that = (TimestampedValue)other;
        return Objects.equals(this.value, that.value) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.timestamp);
    }

    public String toString() {
        return "TimestampedValue(" + this.value + ", " + this.timestamp + ")";
    }

    protected TimestampedValue(@Nullable V value, Instant timestamp) {
        Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp must be non-null");
        this.value = value;
        this.timestamp = timestamp;
    }

    public static class TimestampedValueCoder<T>
    extends StructuredCoder<TimestampedValue<T>> {
        private final Coder<T> valueCoder;

        public static <T> TimestampedValueCoder<T> of(Coder<T> valueCoder) {
            return new TimestampedValueCoder<T>(valueCoder);
        }

        @Override
        public Object structuralValue(TimestampedValue<T> value) {
            Object structuralValue = this.valueCoder.structuralValue(value.getValue());
            return TimestampedValue.of(structuralValue, value.getTimestamp());
        }

        TimestampedValueCoder(Coder<T> valueCoder) {
            this.valueCoder = (Coder)Preconditions.checkNotNull(valueCoder);
        }

        @Override
        public void encode(TimestampedValue<T> windowedElem, OutputStream outStream) throws IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream);
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream);
        }

        @Override
        public TimestampedValue<T> decode(InputStream inStream) throws IOException {
            T value = this.valueCoder.decode(inStream);
            Instant timestamp = InstantCoder.of().decode(inStream);
            return TimestampedValue.of(value, timestamp);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            TimestampedValueCoder.verifyDeterministic(this, "TimestampedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }

        public Coder<T> getValueCoder() {
            return this.valueCoder;
        }

        @Override
        public TypeDescriptor<TimestampedValue<T>> getEncodedTypeDescriptor() {
            return new TypeDescriptor<TimestampedValue<T>>(){}.where(new TypeParameter<T>(){}, this.valueCoder.getEncodedTypeDescriptor());
        }

        @Override
        public List<? extends Coder<?>> getComponents() {
            return Collections.singletonList(this.valueCoder);
        }
    }
}

