/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PCollectionTuple
implements PInput,
POutput {
    final Pipeline pipeline;
    final Map<TupleTag<?>, PCollection<?>> pcollectionMap;

    public static PCollectionTuple empty(Pipeline pipeline) {
        return new PCollectionTuple(pipeline);
    }

    public static <T> PCollectionTuple of(TupleTag<T> tag, PCollection<T> pc) {
        return PCollectionTuple.empty(pc.getPipeline()).and(tag, pc);
    }

    public static <T> PCollectionTuple of(String tag, PCollection<T> pc) {
        return PCollectionTuple.of(new TupleTag(tag), pc);
    }

    public static <T> PCollectionTuple of(String tag1, PCollection<T> pc1, String tag2, PCollection<T> pc2) {
        return PCollectionTuple.of(tag1, pc1).and(tag2, pc2);
    }

    public static <T> PCollectionTuple of(String tag1, PCollection<T> pc1, String tag2, PCollection<T> pc2, String tag3, PCollection<T> pc3) {
        return PCollectionTuple.of(tag1, pc1, tag2, pc2).and(tag3, pc3);
    }

    public static <T> PCollectionTuple of(String tag1, PCollection<T> pc1, String tag2, PCollection<T> pc2, String tag3, PCollection<T> pc3, String tag4, PCollection<T> pc4) {
        return PCollectionTuple.of(tag1, pc1, tag2, pc2, tag3, pc3).and(tag4, pc4);
    }

    public static <T> PCollectionTuple of(String tag1, PCollection<T> pc1, String tag2, PCollection<T> pc2, String tag3, PCollection<T> pc3, String tag4, PCollection<T> pc4, String tag5, PCollection<T> pc5) {
        return PCollectionTuple.of(tag1, pc1, tag2, pc2, tag3, pc3, tag4, pc4).and(tag5, pc5);
    }

    public <T> PCollectionTuple and(TupleTag<T> tag, PCollection<T> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        return new PCollectionTuple(this.pipeline, (Map<TupleTag<?>, PCollection<?>>)new ImmutableMap.Builder().putAll(this.pcollectionMap).put(tag, pc).build());
    }

    public <T> PCollectionTuple and(String tag, PCollection<T> pc) {
        return this.and(new TupleTag(tag), pc);
    }

    public <T> boolean has(TupleTag<T> tag) {
        return this.pcollectionMap.containsKey(tag);
    }

    public <T> boolean has(String tag) {
        return this.has(new TupleTag(tag));
    }

    public <T> PCollection<T> get(TupleTag<T> tag) {
        PCollection<?> pcollection = this.pcollectionMap.get(tag);
        if (pcollection == null) {
            throw new IllegalArgumentException("TupleTag not found in this PCollectionTuple tuple");
        }
        return pcollection;
    }

    public <T> PCollection<T> get(String tag) {
        return this.get(new TupleTag(tag));
    }

    public Map<TupleTag<?>, PCollection<?>> getAll() {
        return this.pcollectionMap;
    }

    public <OutputT extends POutput> OutputT apply(PTransform<? super PCollectionTuple, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<? super PCollectionTuple, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionTuple(Pipeline pipeline) {
        this(pipeline, new LinkedHashMap());
    }

    PCollectionTuple(Pipeline pipeline, Map<TupleTag<?>, PCollection<?>> pcollectionMap) {
        this.pipeline = pipeline;
        this.pcollectionMap = Collections.unmodifiableMap(pcollectionMap);
    }

    @Internal
    public static PCollectionTuple ofPrimitiveOutputsInternal(Pipeline pipeline, TupleTagList outputTags, Map<TupleTag<?>, Coder<?>> coders, WindowingStrategy<?, ?> windowingStrategy, PCollection.IsBounded isBounded) {
        LinkedHashMap pcollectionMap = new LinkedHashMap();
        for (TupleTag<?> outputTag : outputTags.tupleTags) {
            if (pcollectionMap.containsKey(outputTag)) {
                throw new IllegalArgumentException("TupleTag already present in this tuple");
            }
            PCollection<?> outputCollection = PCollection.createPrimitiveOutputInternal(pipeline, windowingStrategy, isBounded, coders.get(outputTag)).setTypeDescriptor(outputTag.getTypeDescriptor());
            pcollectionMap.put(outputTag, outputCollection);
        }
        return new PCollectionTuple(pipeline, pcollectionMap);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Map<TupleTag<?>, PValue> expand() {
        return ImmutableMap.copyOf(this.pcollectionMap);
    }

    @Override
    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        int i = 0;
        for (Map.Entry<TupleTag<?>, PCollection<?>> entry : this.pcollectionMap.entrySet()) {
            TupleTag<?> tag = entry.getKey();
            PCollection<?> pc = entry.getValue();
            if (pc.getName().equals(PValueBase.defaultName(transformName))) {
                pc.setName(String.format("%s.%s", transformName, tag.getOutName(i)));
            }
            ++i;
        }
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof PCollectionTuple)) {
            return false;
        }
        PCollectionTuple that = (PCollectionTuple)other;
        return this.pipeline.equals(that.pipeline) && this.pcollectionMap.equals(that.pcollectionMap);
    }

    public int hashCode() {
        return Objects.hash(this.pipeline, this.pcollectionMap);
    }
}

