/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IncompatibleWindowException;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PartitioningWindowFn;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class FixedWindows
extends PartitioningWindowFn<Object, IntervalWindow> {
    private final Duration size;
    private final Duration offset;

    public static FixedWindows of(Duration size) {
        return new FixedWindows(size, Duration.ZERO);
    }

    public FixedWindows withOffset(Duration offset) {
        return new FixedWindows(this.size, offset);
    }

    private FixedWindows(Duration size, Duration offset) {
        if (offset.isShorterThan((ReadableDuration)Duration.ZERO) || !offset.isShorterThan((ReadableDuration)size)) {
            throw new IllegalArgumentException("FixedWindows WindowingStrategies must have 0 <= offset < size");
        }
        this.size = size;
        this.offset = offset;
    }

    @Override
    public IntervalWindow assignWindow(Instant timestamp) {
        Instant endOfGlobalWindow;
        Instant start = new Instant(timestamp.getMillis() - timestamp.plus((ReadableDuration)this.size).minus((ReadableDuration)this.offset).getMillis() % this.size.getMillis());
        Instant end = start.isAfter((ReadableInstant)(endOfGlobalWindow = GlobalWindow.INSTANCE.maxTimestamp().plus(1L)).minus((ReadableDuration)this.size)) ? endOfGlobalWindow : start.plus((ReadableDuration)this.size);
        return new IntervalWindow(start, end);
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item("size", this.size).withLabel("Window Duration")).addIfNotDefault(DisplayData.item("offset", this.offset).withLabel("Window Start Offset"), Duration.ZERO);
    }

    @Override
    public Coder<IntervalWindow> windowCoder() {
        return IntervalWindow.getCoder();
    }

    @Override
    public boolean isCompatible(WindowFn<?, ?> other) {
        return this.equals(other);
    }

    @Override
    public void verifyCompatibility(WindowFn<?, ?> other) throws IncompatibleWindowException {
        if (!this.isCompatible(other)) {
            throw new IncompatibleWindowException(other, String.format("Only %s objects with the same size and offset are compatible.", FixedWindows.class.getSimpleName()));
        }
    }

    public Duration getSize() {
        return this.size;
    }

    public Duration getOffset() {
        return this.offset;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof FixedWindows)) {
            return false;
        }
        FixedWindows other = (FixedWindows)object;
        return this.getOffset().equals((Object)other.getOffset()) && this.getSize().equals((Object)other.getSize());
    }

    public int hashCode() {
        return Objects.hash(this.size, this.offset);
    }
}

