/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.ByteBuddyDoFnInvokerFactory;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;

@Internal
public class DoFnInvokers {
    public static <InputT, OutputT> DoFnInvoker<InputT, OutputT> invokerFor(DoFn<InputT, OutputT> fn) {
        return ByteBuddyDoFnInvokerFactory.only().newByteBuddyInvoker(fn);
    }

    private DoFnInvokers() {
    }

    public static <InputT, OutputT> DoFnInvoker<InputT, OutputT> tryInvokeSetupFor(DoFn<InputT, OutputT> fn, PipelineOptions options) {
        DoFnInvoker doFnInvoker = DoFnInvokers.invokerFor(fn);
        try {
            doFnInvoker.invokeSetup(new DoFnSetupArgumentProvider(fn, options));
        }
        catch (Exception e) {
            try {
                doFnInvoker.invokeTeardown();
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
        return doFnInvoker;
    }

    private static class DoFnSetupArgumentProvider<InputT, OutputT>
    extends DoFnInvoker.BaseArgumentProvider<InputT, OutputT> {
        private final DoFn fn;
        private final PipelineOptions options;

        private DoFnSetupArgumentProvider(DoFn fn, PipelineOptions options) {
            this.fn = fn;
            this.options = options;
        }

        @Override
        public PipelineOptions pipelineOptions() {
            return this.options;
        }

        @Override
        public String getErrorContext() {
            return "SimpleDoFnRunner/Setup";
        }
    }
}

