/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.util.common.Reiterator;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.PeekingIterator;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoGbkResult {
    private final List<Iterable<?>> valueMap;
    private final CoGbkResultSchema schema;
    private static final int DEFAULT_IN_MEMORY_ELEMENT_COUNT = 10000;
    private static final Logger LOG = LoggerFactory.getLogger(CoGbkResult.class);
    private int nextTestUnionId = 0;

    public CoGbkResult(CoGbkResultSchema schema, Iterable<RawUnionValue> taggedValues) {
        this(schema, taggedValues, 10000);
    }

    public CoGbkResult(CoGbkResultSchema schema, Iterable<RawUnionValue> taggedValues, int inMemoryElementCount) {
        this.schema = schema;
        this.valueMap = new ArrayList();
        for (int unionTag = 0; unionTag < schema.size(); ++unionTag) {
            this.valueMap.add(new ArrayList());
        }
        Iterator<RawUnionValue> taggedIter = taggedValues.iterator();
        int elementCount = 0;
        while (taggedIter.hasNext() && (elementCount++ < inMemoryElementCount || !(taggedIter instanceof Reiterator))) {
            RawUnionValue value = taggedIter.next();
            int unionTag = value.getUnionTag();
            if (schema.size() <= unionTag) {
                throw new IllegalStateException("union tag " + unionTag + " has no corresponding tuple tag in the result schema");
            }
            List valueList = (List)this.valueMap.get(unionTag);
            valueList.add(value.getValue());
        }
        if (taggedIter.hasNext()) {
            LOG.info("CoGbkResult has more than {} elements, reiteration (which may be slow) is required.", (Object)inMemoryElementCount);
            Reiterator tail = (Reiterator)taggedIter;
            Boolean[] containsTag = new Boolean[schema.size()];
            for (int unionTag = 0; unionTag < schema.size(); ++unionTag) {
                this.updateUnionTag(tail, containsTag, unionTag);
            }
        }
    }

    private <T> void updateUnionTag(Reiterator<RawUnionValue> tail, Boolean[] containsTag, int unionTag) {
        Iterable<?> head = this.valueMap.get(unionTag);
        this.valueMap.set(unionTag, () -> Iterators.concat(head.iterator(), new UnionValueIterator(unionTag, tail.copy(), containsTag)));
    }

    public boolean isEmpty() {
        for (Iterable<?> tagValues : this.valueMap) {
            if (!tagValues.iterator().hasNext()) continue;
            return false;
        }
        return true;
    }

    public CoGbkResultSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        return this.valueMap.toString();
    }

    public <V> Iterable<V> getAll(TupleTag<V> tag) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterable<?> unions = this.valueMap.get(index);
        return unions;
    }

    public <V> Iterable<V> getAll(String tag) {
        return this.getAll(new TupleTag(tag));
    }

    public <V> V getOnly(TupleTag<V> tag) {
        return this.innerGetOnly(tag, null, false);
    }

    public <V> V getOnly(String tag) {
        return this.getOnly(new TupleTag(tag));
    }

    public <V> @Nullable V getOnly(TupleTag<V> tag, @Nullable V defaultValue) {
        return this.innerGetOnly(tag, defaultValue, true);
    }

    public <V> @Nullable V getOnly(String tag, @Nullable V defaultValue) {
        return this.getOnly(new TupleTag(tag), defaultValue);
    }

    public static <V> CoGbkResult of(TupleTag<V> tag, List<V> data) {
        return CoGbkResult.empty().and(tag, data);
    }

    public <V> CoGbkResult and(TupleTag<V> tag, List<V> data) {
        if (this.nextTestUnionId != this.schema.size()) {
            throw new IllegalArgumentException("Attempting to call and() on a CoGbkResult apparently not created by of().");
        }
        ArrayList valueMap = new ArrayList(this.valueMap);
        valueMap.add(data);
        return new CoGbkResult(new CoGbkResultSchema(this.schema.getTupleTagList().and(tag)), (List<Iterable<?>>)valueMap, this.nextTestUnionId + 1);
    }

    public static <V> CoGbkResult empty() {
        return new CoGbkResult(new CoGbkResultSchema(TupleTagList.empty()), new ArrayList());
    }

    private CoGbkResult(CoGbkResultSchema schema, List<Iterable<?>> valueMap, int nextTestUnionId) {
        this(schema, valueMap);
        this.nextTestUnionId = nextTestUnionId;
    }

    private CoGbkResult(CoGbkResultSchema schema, List<Iterable<?>> valueMap) {
        this.schema = schema;
        this.valueMap = valueMap;
    }

    private <V> @Nullable V innerGetOnly(TupleTag<V> tag, @Nullable V defaultValue, boolean useDefault) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterator<?> unions = this.valueMap.get(index).iterator();
        if (!unions.hasNext()) {
            if (useDefault) {
                return defaultValue;
            }
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to an empty result, and no default was provided");
        }
        Object value = unions.next();
        if (unions.hasNext()) {
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to a non-singleton result");
        }
        return (V)value;
    }

    private static class UnionValueIterator<V>
    implements Iterator<V> {
        private final int tag;
        private final PeekingIterator<RawUnionValue> unions;
        private final Boolean[] containsTag;

        private UnionValueIterator(int tag, Iterator<RawUnionValue> unions, Boolean[] containsTag) {
            this.tag = tag;
            this.unions = Iterators.peekingIterator(unions);
            this.containsTag = containsTag;
        }

        @Override
        public boolean hasNext() {
            if (Boolean.FALSE.equals(this.containsTag[this.tag])) {
                return false;
            }
            this.advance();
            if (this.unions.hasNext()) {
                return true;
            }
            for (int i = 0; i < this.containsTag.length; ++i) {
                if (this.containsTag[i] != null) continue;
                this.containsTag[i] = false;
            }
            return false;
        }

        @Override
        public V next() {
            this.advance();
            return (V)((RawUnionValue)this.unions.next()).getValue();
        }

        private void advance() {
            while (this.unions.hasNext()) {
                int curTag = ((RawUnionValue)this.unions.peek()).getUnionTag();
                this.containsTag[curTag] = true;
                if (curTag == this.tag) break;
                this.unions.next();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class CoGbkResultCoder
    extends CustomCoder<CoGbkResult> {
        private final CoGbkResultSchema schema;
        private final UnionCoder unionCoder;

        public static CoGbkResultCoder of(CoGbkResultSchema schema, UnionCoder unionCoder) {
            return new CoGbkResultCoder(schema, unionCoder);
        }

        private CoGbkResultCoder(CoGbkResultSchema tupleTags, UnionCoder unionCoder) {
            this.schema = tupleTags;
            this.unionCoder = unionCoder;
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return ImmutableList.of((Object)this.unionCoder);
        }

        public CoGbkResultSchema getSchema() {
            return this.schema;
        }

        public UnionCoder getUnionCoder() {
            return this.unionCoder;
        }

        @Override
        public void encode(CoGbkResult value, OutputStream outStream) throws CoderException, IOException {
            if (!this.schema.equals(value.getSchema())) {
                throw new CoderException("input schema does not match coder schema");
            }
            if (this.schema.size() == 0) {
                return;
            }
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                this.tagListCoder(unionTag).encode((Iterable)value.valueMap.get(unionTag), outStream);
            }
        }

        @Override
        public CoGbkResult decode(InputStream inStream) throws CoderException, IOException {
            if (this.schema.size() == 0) {
                return new CoGbkResult(this.schema, (List)ImmutableList.of());
            }
            ArrayList valueMap = Lists.newArrayListWithExpectedSize((int)this.schema.size());
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                valueMap.add(this.tagListCoder(unionTag).decode(inStream));
            }
            return new CoGbkResult(this.schema, (List)valueMap);
        }

        private IterableCoder tagListCoder(int unionTag) {
            return IterableCoder.of(this.unionCoder.getElementCoders().get(unionTag));
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CoGbkResultCoder)) {
                return false;
            }
            CoGbkResultCoder other = (CoGbkResultCoder)object;
            return this.schema.equals(other.schema) && this.unionCoder.equals(other.unionCoder);
        }

        public int hashCode() {
            return Objects.hashCode(this.schema);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            CoGbkResultCoder.verifyDeterministic(this, "CoGbkResult requires the union coder to be deterministic", this.unionCoder);
        }
    }
}

