/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class Regex {
    private Regex() {
    }

    public static Matches matches(String regex) {
        return Regex.matches(regex, 0);
    }

    public static Matches matches(Pattern pattern) {
        return Regex.matches(pattern, 0);
    }

    public static Matches matches(String regex, int group) {
        return Regex.matches(Pattern.compile(regex), group);
    }

    public static Matches matches(Pattern pattern, int group) {
        return new Matches(pattern, group);
    }

    public static MatchesName matches(String regex, String groupName) {
        return Regex.matches(Pattern.compile(regex), groupName);
    }

    public static MatchesName matches(Pattern pattern, String groupName) {
        return new MatchesName(pattern, groupName);
    }

    public static AllMatches allMatches(String regex) {
        return Regex.allMatches(Pattern.compile(regex));
    }

    public static AllMatches allMatches(Pattern pattern) {
        return new AllMatches(pattern);
    }

    public static MatchesKV matchesKV(String regex, int keyGroup, int valueGroup) {
        return Regex.matchesKV(Pattern.compile(regex), keyGroup, valueGroup);
    }

    public static MatchesKV matchesKV(Pattern pattern, int keyGroup, int valueGroup) {
        return new MatchesKV(pattern, keyGroup, valueGroup);
    }

    public static MatchesNameKV matchesKV(String regex, String keyGroupName, String valueGroupName) {
        return Regex.matchesKV(Pattern.compile(regex), keyGroupName, valueGroupName);
    }

    public static MatchesNameKV matchesKV(Pattern pattern, String keyGroupName, String valueGroupName) {
        return new MatchesNameKV(pattern, keyGroupName, valueGroupName);
    }

    public static Find find(String regex) {
        return Regex.find(regex, 0);
    }

    public static Find find(Pattern pattern) {
        return Regex.find(pattern, 0);
    }

    public static Find find(String regex, int group) {
        return Regex.find(Pattern.compile(regex), group);
    }

    public static Find find(Pattern pattern, int group) {
        return new Find(pattern, group);
    }

    public static FindName find(String regex, String groupName) {
        return Regex.find(Pattern.compile(regex), groupName);
    }

    public static FindName find(Pattern pattern, String groupName) {
        return new FindName(pattern, groupName);
    }

    public static FindAll findAll(String regex) {
        return Regex.findAll(Pattern.compile(regex));
    }

    public static FindAll findAll(Pattern pattern) {
        return new FindAll(pattern);
    }

    public static FindKV findKV(String regex, int keyGroup, int valueGroup) {
        return Regex.findKV(Pattern.compile(regex), keyGroup, valueGroup);
    }

    public static FindKV findKV(Pattern pattern, int keyGroup, int valueGroup) {
        return new FindKV(pattern, keyGroup, valueGroup);
    }

    public static FindNameKV findKV(String regex, String keyGroupName, String valueGroupName) {
        return Regex.findKV(Pattern.compile(regex), keyGroupName, valueGroupName);
    }

    public static FindNameKV findKV(Pattern pattern, String keyGroupName, String valueGroupName) {
        return new FindNameKV(pattern, keyGroupName, valueGroupName);
    }

    public static ReplaceAll replaceAll(String regex, String replacement) {
        return Regex.replaceAll(Pattern.compile(regex), replacement);
    }

    public static ReplaceAll replaceAll(Pattern pattern, String replacement) {
        return new ReplaceAll(pattern, replacement);
    }

    public static ReplaceFirst replaceFirst(String regex, String replacement) {
        return Regex.replaceFirst(Pattern.compile(regex), replacement);
    }

    public static ReplaceFirst replaceFirst(Pattern pattern, String replacement) {
        return new ReplaceFirst(pattern, replacement);
    }

    public static Split split(String regex) {
        return Regex.split(Pattern.compile(regex), false);
    }

    public static Split split(Pattern pattern) {
        return Regex.split(pattern, false);
    }

    public static Split split(String regex, boolean outputEmpty) {
        return Regex.split(Pattern.compile(regex), outputEmpty);
    }

    public static Split split(Pattern pattern, boolean outputEmpty) {
        return new Split(pattern, outputEmpty);
    }

    public static class Split
    extends PTransform<PCollection<String>, PCollection<String>> {
        final Pattern pattern;
        boolean outputEmpty;

        public Split(Pattern pattern, boolean outputEmpty) {
            this.pattern = pattern;
            this.outputEmpty = outputEmpty;
        }

        @Override
        public PCollection<String> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<String> r) throws Exception {
                    String[] items;
                    for (String item : items = pattern.split(element)) {
                        if (!outputEmpty && item.isEmpty()) continue;
                        r.output(item);
                    }
                }
            })));
        }
    }

    public static class ReplaceFirst
    extends PTransform<PCollection<String>, PCollection<String>> {
        final Pattern pattern;
        String replacement;

        public ReplaceFirst(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Override
        public PCollection<String> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<String> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    r.output(m.replaceFirst(replacement));
                }
            })));
        }
    }

    public static class ReplaceAll
    extends PTransform<PCollection<String>, PCollection<String>> {
        final Pattern pattern;
        String replacement;

        public ReplaceAll(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Override
        public PCollection<String> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<String> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    r.output(m.replaceAll(replacement));
                }
            })));
        }
    }

    public static class FindNameKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final Pattern pattern;
        String keyGroupName;
        String valueGroupName;

        public FindNameKV(Pattern pattern, String keyGroupName, String valueGroupName) {
            this.pattern = pattern;
            this.keyGroupName = keyGroupName;
            this.valueGroupName = valueGroupName;
        }

        @Override
        public PCollection<KV<String, String>> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<KV<String, String>> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroupName), m.group(valueGroupName)));
                    }
                }
            })));
        }
    }

    public static class FindKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final Pattern pattern;
        int keyGroup;
        int valueGroup;

        public FindKV(Pattern pattern, int keyGroup, int valueGroup) {
            this.pattern = pattern;
            this.keyGroup = keyGroup;
            this.valueGroup = valueGroup;
        }

        @Override
        public PCollection<KV<String, String>> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<KV<String, String>> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroup), m.group(valueGroup)));
                    }
                }
            })));
        }
    }

    public static class FindAll
    extends PTransform<PCollection<String>, PCollection<List<String>>> {
        final Pattern pattern;

        public FindAll(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public PCollection<List<String>> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, List<String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<List<String>> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        ArrayList<String> list = new ArrayList<String>(m.groupCount());
                        for (int i = 0; i < m.groupCount() + 1; ++i) {
                            list.add(m.group(i));
                        }
                        r.output(list);
                    }
                }
            })));
        }
    }

    public static class FindName
    extends PTransform<PCollection<String>, PCollection<String>> {
        final Pattern pattern;
        String groupName;

        public FindName(Pattern pattern, String groupName) {
            this.pattern = pattern;
            this.groupName = groupName;
        }

        @Override
        public PCollection<String> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<String> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(m.group(groupName));
                    }
                }
            })));
        }
    }

    public static class Find
    extends PTransform<PCollection<String>, PCollection<String>> {
        final Pattern pattern;
        int group;

        public Find(Pattern pattern, int group) {
            this.pattern = pattern;
            this.group = group;
        }

        @Override
        public PCollection<String> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<String> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(m.group(group));
                    }
                }
            })));
        }
    }

    public static class MatchesNameKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final Pattern pattern;
        String keyGroupName;
        String valueGroupName;

        public MatchesNameKV(Pattern pattern, String keyGroupName, String valueGroupName) {
            this.pattern = pattern;
            this.keyGroupName = keyGroupName;
            this.valueGroupName = valueGroupName;
        }

        @Override
        public PCollection<KV<String, String>> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<KV<String, String>> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroupName), m.group(valueGroupName)));
                    }
                }
            })));
        }
    }

    public static class MatchesKV
    extends PTransform<PCollection<String>, PCollection<KV<String, String>>> {
        final Pattern pattern;
        int keyGroup;
        int valueGroup;

        public MatchesKV(Pattern pattern, int keyGroup, int valueGroup) {
            this.pattern = pattern;
            this.keyGroup = keyGroup;
            this.valueGroup = valueGroup;
        }

        @Override
        public PCollection<KV<String, String>> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, KV<String, String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<KV<String, String>> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.find()) {
                        r.output(KV.of(m.group(keyGroup), m.group(valueGroup)));
                    }
                }
            })));
        }
    }

    public static class AllMatches
    extends PTransform<PCollection<String>, PCollection<List<String>>> {
        final Pattern pattern;

        public AllMatches(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public PCollection<List<String>> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, List<String>>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<List<String>> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.matches()) {
                        ArrayList<String> list = new ArrayList<String>(m.groupCount());
                        for (int i = 0; i < m.groupCount() + 1; ++i) {
                            list.add(m.group(i));
                        }
                        r.output(list);
                    }
                }
            })));
        }
    }

    public static class MatchesName
    extends PTransform<PCollection<String>, PCollection<String>> {
        final Pattern pattern;
        String groupName;

        public MatchesName(Pattern pattern, String groupName) {
            this.pattern = pattern;
            this.groupName = groupName;
        }

        @Override
        public PCollection<String> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<String> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.matches()) {
                        r.output(m.group(groupName));
                    }
                }
            })));
        }
    }

    public static class Matches
    extends PTransform<PCollection<String>, PCollection<String>> {
        final Pattern pattern;
        int group;

        public Matches(Pattern pattern, int group) {
            this.pattern = pattern;
            this.group = group;
        }

        @Override
        public PCollection<String> expand(PCollection<String> in) {
            return (PCollection)((Object)in.apply(ParDo.of(new DoFn<String, String>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element String element, DoFn.OutputReceiver<String> r) throws Exception {
                    Matcher m = pattern.matcher(element);
                    if (m.matches()) {
                        r.output(m.group(group));
                    }
                }
            })));
        }
    }
}

