/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.values.PCollectionView;

public class CombineWithContext {

    public static abstract class CombineFnWithContext<InputT, AccumT, OutputT>
    extends CombineFnBase.AbstractGlobalCombineFn<InputT, AccumT, OutputT>
    implements RequiresContextInternal {
        public abstract AccumT createAccumulator(Context var1);

        public abstract AccumT addInput(AccumT var1, InputT var2, Context var3);

        public abstract AccumT mergeAccumulators(Iterable<AccumT> var1, Context var2);

        public abstract OutputT extractOutput(AccumT var1, Context var2);

        public AccumT compact(AccumT accumulator, Context c) {
            return accumulator;
        }

        public OutputT apply(Iterable<? extends InputT> inputs, Context c) {
            AccumT accum = this.createAccumulator(c);
            for (InputT input : inputs) {
                accum = this.addInput(accum, input, c);
            }
            return this.extractOutput(accum, c);
        }

        @Override
        public OutputT defaultValue() {
            throw new UnsupportedOperationException("Override this function to provide the default value.");
        }
    }

    public static interface RequiresContextInternal {
    }

    public static abstract class Context {
        public abstract PipelineOptions getPipelineOptions();

        public abstract <T> T sideInput(PCollectionView<T> var1);
    }
}

