/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public abstract class JsonMatcher<T>
extends TypeSafeMatcher<T> {
    private Matcher<Map<String, Object>> mapMatcher;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private Map<String, Object> actualMap;

    public JsonMatcher(Map<String, Object> expectedMap) {
        this.mapMatcher = Matchers.is(expectedMap);
    }

    protected abstract Map<String, Object> parse(T var1) throws IOException;

    public static Matcher<byte[]> jsonBytesLike(String json) throws IOException {
        Map fields = (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return JsonMatcher.jsonBytesLike(fields);
    }

    public static Matcher<byte[]> jsonBytesLike(Map<String, Object> fields) throws IOException {
        return new JsonMatcher<byte[]>(fields){

            @Override
            protected Map<String, Object> parse(byte[] json) throws IOException {
                return (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        };
    }

    public static Matcher<String> jsonStringLike(String json) throws IOException {
        Map fields = (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return JsonMatcher.jsonStringLike(fields);
    }

    public static Matcher<String> jsonStringLike(Map<String, Object> fields) throws IOException {
        return new JsonMatcher<String>(fields){

            @Override
            protected Map<String, Object> parse(String json) throws IOException {
                return (Map)MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        };
    }

    protected boolean matchesSafely(T actual) {
        try {
            this.actualMap = this.parse(actual);
        }
        catch (IOException e) {
            return false;
        }
        return this.mapMatcher.matches(this.actualMap);
    }

    public void describeTo(Description description) {
        this.mapMatcher.describeTo(description);
    }

    protected void describeMismatchSafely(T item, Description mismatchDescription) {
        this.mapMatcher.describeMismatch(this.actualMap, mismatchDescription);
    }
}

