/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.RowCoderGenerator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoderHelpers;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SchemaCoder<T>
extends CustomCoder<T> {
    protected final Schema schema;
    private final TypeDescriptor<T> typeDescriptor;
    private final SerializableFunction<T, Row> toRowFunction;
    private final SerializableFunction<Row, T> fromRowFunction;
    private transient @Nullable Coder<Row> delegateCoder;

    protected SchemaCoder(Schema schema, TypeDescriptor<T> typeDescriptor, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
        Preconditions.checkArgument((!typeDescriptor.hasUnresolvedParameters() ? 1 : 0) != 0, (String)"Cannot create SchemaCoder with a TypeDescriptor that has unresolved parameters: %s", typeDescriptor);
        if (schema.getUUID() == null) {
            schema = SerializableUtils.clone(schema);
            SchemaCoder.setSchemaIds(schema);
        }
        this.toRowFunction = toRowFunction;
        this.fromRowFunction = fromRowFunction;
        this.typeDescriptor = typeDescriptor;
        this.schema = schema;
    }

    public static <T> SchemaCoder<T> of(Schema schema, TypeDescriptor<T> typeDescriptor, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
        return new SchemaCoder<T>(schema, typeDescriptor, toRowFunction, fromRowFunction);
    }

    public static SchemaCoder<Row> of(Schema schema) {
        return RowCoder.of(schema);
    }

    public static void overrideEncodingPositions(UUID uuid, Map<String, Integer> encodingPositions) {
        RowCoderGenerator.overrideEncodingPositions(uuid, encodingPositions);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SerializableFunction<Row, T> getFromRowFunction() {
        return this.fromRowFunction;
    }

    public SerializableFunction<T, Row> getToRowFunction() {
        return this.toRowFunction;
    }

    private Coder<Row> getDelegateCoder() {
        if (this.delegateCoder == null) {
            this.delegateCoder = RowCoderGenerator.generate(this.schema);
        }
        return this.delegateCoder;
    }

    @Override
    public void encode(T value, OutputStream outStream) throws IOException {
        this.getDelegateCoder().encode(this.toRowFunction.apply(value), outStream);
    }

    @Override
    public T decode(InputStream inStream) throws IOException {
        return this.fromRowFunction.apply(this.getDelegateCoder().decode(inStream));
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.verifyDeterministic(this.schema);
    }

    private void verifyDeterministic(Schema schema) throws Coder.NonDeterministicException {
        ImmutableList coders = (ImmutableList)schema.getFields().stream().map(Schema.Field::getType).map(SchemaCoderHelpers::coderForFieldType).collect(ImmutableList.toImmutableList());
        Coder.verifyDeterministic(this, "All fields must have deterministic encoding", coders);
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    public static <T> Coder<T> coderForFieldType(Schema.FieldType fieldType) {
        return SchemaCoderHelpers.coderForFieldType(fieldType);
    }

    public String toString() {
        return "SchemaCoder<Schema: " + this.schema + "  UUID: " + this.schema.getUUID() + " delegateCoder: " + this.getDelegateCoder();
    }

    private static void setSchemaIds(Schema schema) {
        if (schema.getUUID() == null) {
            schema.setUUID(UUID.randomUUID());
        }
        for (Schema.Field field : schema.getFields()) {
            SchemaCoder.setSchemaIds(field.getType());
        }
    }

    private static void setSchemaIds(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ROW: {
                SchemaCoder.setSchemaIds(fieldType.getRowSchema());
                return;
            }
            case MAP: {
                SchemaCoder.setSchemaIds(fieldType.getMapKeyType());
                SchemaCoder.setSchemaIds(fieldType.getMapValueType());
                return;
            }
            case LOGICAL_TYPE: {
                SchemaCoder.setSchemaIds(fieldType.getLogicalType().getBaseType());
                return;
            }
            case ARRAY: 
            case ITERABLE: {
                SchemaCoder.setSchemaIds(fieldType.getCollectionElementType());
                return;
            }
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaCoder that = (SchemaCoder)o;
        return this.schema.equals(that.schema) && this.typeDescriptor.equals(that.typeDescriptor) && this.toRowFunction.equals(that.toRowFunction) && this.fromRowFunction.equals(that.fromRowFunction);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.typeDescriptor, this.toRowFunction, this.fromRowFunction);
    }

    private static RowIdentity identity() {
        return new RowIdentity();
    }

    @Override
    public TypeDescriptor<T> getEncodedTypeDescriptor() {
        return this.typeDescriptor;
    }

    private static class RowIdentity
    implements SerializableFunction<Row, Row> {
        private RowIdentity() {
        }

        @Override
        public Row apply(Row input) {
            return input;
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }
}

