/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_FieldValueTypeInformation
extends FieldValueTypeInformation {
    private final String name;
    private final boolean nullable;
    private final TypeDescriptor type;
    private final Class rawType;
    private final @Nullable Field field;
    private final @Nullable Method method;
    private final Map<String, FieldValueTypeInformation> oneOfTypes;
    private final @Nullable FieldValueTypeInformation elementType;
    private final @Nullable FieldValueTypeInformation mapKeyType;
    private final @Nullable FieldValueTypeInformation mapValueType;

    private AutoValue_FieldValueTypeInformation(String name, boolean nullable, TypeDescriptor type, Class rawType, @Nullable Field field, @Nullable Method method, Map<String, FieldValueTypeInformation> oneOfTypes, @Nullable FieldValueTypeInformation elementType, @Nullable FieldValueTypeInformation mapKeyType, @Nullable FieldValueTypeInformation mapValueType) {
        this.name = name;
        this.nullable = nullable;
        this.type = type;
        this.rawType = rawType;
        this.field = field;
        this.method = method;
        this.oneOfTypes = oneOfTypes;
        this.elementType = elementType;
        this.mapKeyType = mapKeyType;
        this.mapValueType = mapValueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public TypeDescriptor getType() {
        return this.type;
    }

    @Override
    public Class getRawType() {
        return this.rawType;
    }

    @Override
    public @Nullable Field getField() {
        return this.field;
    }

    @Override
    public @Nullable Method getMethod() {
        return this.method;
    }

    @Override
    public Map<String, FieldValueTypeInformation> getOneOfTypes() {
        return this.oneOfTypes;
    }

    @Override
    public @Nullable FieldValueTypeInformation getElementType() {
        return this.elementType;
    }

    @Override
    public @Nullable FieldValueTypeInformation getMapKeyType() {
        return this.mapKeyType;
    }

    @Override
    public @Nullable FieldValueTypeInformation getMapValueType() {
        return this.mapValueType;
    }

    public String toString() {
        return "FieldValueTypeInformation{name=" + this.name + ", nullable=" + this.nullable + ", type=" + this.type + ", rawType=" + this.rawType + ", field=" + this.field + ", method=" + this.method + ", oneOfTypes=" + this.oneOfTypes + ", elementType=" + this.elementType + ", mapKeyType=" + this.mapKeyType + ", mapValueType=" + this.mapValueType + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FieldValueTypeInformation) {
            FieldValueTypeInformation that = (FieldValueTypeInformation)o;
            return this.name.equals(that.getName()) && this.nullable == that.isNullable() && this.type.equals(that.getType()) && this.rawType.equals(that.getRawType()) && (this.field == null ? that.getField() == null : this.field.equals(that.getField())) && (this.method == null ? that.getMethod() == null : this.method.equals(that.getMethod())) && this.oneOfTypes.equals(that.getOneOfTypes()) && (this.elementType == null ? that.getElementType() == null : this.elementType.equals(that.getElementType())) && (this.mapKeyType == null ? that.getMapKeyType() == null : this.mapKeyType.equals(that.getMapKeyType())) && (this.mapValueType == null ? that.getMapValueType() == null : this.mapValueType.equals(that.getMapValueType()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.nullable ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.rawType.hashCode();
        h$ *= 1000003;
        h$ ^= this.field == null ? 0 : this.field.hashCode();
        h$ *= 1000003;
        h$ ^= this.method == null ? 0 : this.method.hashCode();
        h$ *= 1000003;
        h$ ^= this.oneOfTypes.hashCode();
        h$ *= 1000003;
        h$ ^= this.elementType == null ? 0 : this.elementType.hashCode();
        h$ *= 1000003;
        h$ ^= this.mapKeyType == null ? 0 : this.mapKeyType.hashCode();
        h$ *= 1000003;
        return h$ ^= this.mapValueType == null ? 0 : this.mapValueType.hashCode();
    }

    @Override
    FieldValueTypeInformation.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FieldValueTypeInformation.Builder {
        private String name;
        private Boolean nullable;
        private TypeDescriptor type;
        private Class rawType;
        private @Nullable Field field;
        private @Nullable Method method;
        private Map<String, FieldValueTypeInformation> oneOfTypes;
        private @Nullable FieldValueTypeInformation elementType;
        private @Nullable FieldValueTypeInformation mapKeyType;
        private @Nullable FieldValueTypeInformation mapValueType;

        Builder() {
        }

        private Builder(FieldValueTypeInformation source) {
            this.name = source.getName();
            this.nullable = source.isNullable();
            this.type = source.getType();
            this.rawType = source.getRawType();
            this.field = source.getField();
            this.method = source.getMethod();
            this.oneOfTypes = source.getOneOfTypes();
            this.elementType = source.getElementType();
            this.mapKeyType = source.getMapKeyType();
            this.mapValueType = source.getMapValueType();
        }

        @Override
        public FieldValueTypeInformation.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setType(TypeDescriptor type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setRawType(Class rawType) {
            if (rawType == null) {
                throw new NullPointerException("Null rawType");
            }
            this.rawType = rawType;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setField(@Nullable Field field) {
            this.field = field;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setMethod(@Nullable Method method) {
            this.method = method;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setOneOfTypes(Map<String, FieldValueTypeInformation> oneOfTypes) {
            if (oneOfTypes == null) {
                throw new NullPointerException("Null oneOfTypes");
            }
            this.oneOfTypes = oneOfTypes;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setElementType(@Nullable FieldValueTypeInformation elementType) {
            this.elementType = elementType;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setMapKeyType(@Nullable FieldValueTypeInformation mapKeyType) {
            this.mapKeyType = mapKeyType;
            return this;
        }

        @Override
        public FieldValueTypeInformation.Builder setMapValueType(@Nullable FieldValueTypeInformation mapValueType) {
            this.mapValueType = mapValueType;
            return this;
        }

        @Override
        FieldValueTypeInformation build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.nullable == null) {
                missing = missing + " nullable";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.rawType == null) {
                missing = missing + " rawType";
            }
            if (this.oneOfTypes == null) {
                missing = missing + " oneOfTypes";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FieldValueTypeInformation(this.name, this.nullable, this.type, this.rawType, this.field, this.method, this.oneOfTypes, this.elementType, this.mapKeyType, this.mapValueType);
        }
    }
}

