/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoder;

public class ReadableFileCoder
extends AtomicCoder<FileIO.ReadableFile> {
    private static final ReadableFileCoder INSTANCE = new ReadableFileCoder();

    public static ReadableFileCoder of() {
        return INSTANCE;
    }

    @Override
    public void encode(FileIO.ReadableFile value, OutputStream os) throws IOException {
        MetadataCoder.of().encode(value.getMetadata(), os);
        VarIntCoder.of().encode(value.getCompression().ordinal(), os);
    }

    @Override
    public FileIO.ReadableFile decode(InputStream is) throws IOException {
        MatchResult.Metadata metadata = MetadataCoder.of().decode(is);
        Compression compression = Compression.values()[VarIntCoder.of().decode(is)];
        return new FileIO.ReadableFile(metadata, compression);
    }
}

