/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.expansion.ExternalTransformRegistrar;
import org.apache.beam.sdk.io.AutoValue_GenerateSequence;
import org.apache.beam.sdk.io.BoundedReadFromUnboundedSource;
import org.apache.beam.sdk.io.CountingSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;

@AutoValue
public abstract class GenerateSequence
extends PTransform<PBegin, PCollection<Long>> {
    abstract long getFrom();

    abstract long getTo();

    abstract @Nullable SerializableFunction<Long, Instant> getTimestampFn();

    abstract long getElementsPerPeriod();

    abstract @Nullable Duration getPeriod();

    abstract @Nullable Duration getMaxReadTime();

    abstract Builder toBuilder();

    public static GenerateSequence from(long from) {
        Preconditions.checkArgument((from >= 0L ? 1 : 0) != 0, (String)"Value of from must be non-negative, but was: %s", (long)from);
        return new AutoValue_GenerateSequence.Builder().setFrom(from).setTo(-1L).setElementsPerPeriod(0L).build();
    }

    public GenerateSequence to(long to) {
        Preconditions.checkArgument((this.getTo() == -1L || this.getTo() >= this.getFrom() ? 1 : 0) != 0, (String)"Degenerate range [%s, %s)", (long)this.getFrom(), (long)this.getTo());
        return this.toBuilder().setTo(to).build();
    }

    public GenerateSequence withTimestampFn(SerializableFunction<Long, Instant> timestampFn) {
        return this.toBuilder().setTimestampFn(timestampFn).build();
    }

    public GenerateSequence withRate(long numElements, Duration periodLength) {
        Preconditions.checkArgument((numElements > 0L ? 1 : 0) != 0, (String)"Number of elements in withRate must be positive, but was: %s", (long)numElements);
        Preconditions.checkArgument((periodLength != null ? 1 : 0) != 0, (Object)"periodLength can not be null");
        return this.toBuilder().setElementsPerPeriod(numElements).setPeriod(periodLength).build();
    }

    public GenerateSequence withMaxReadTime(Duration maxReadTime) {
        return this.toBuilder().setMaxReadTime(maxReadTime).build();
    }

    @Override
    public PCollection<Long> expand(PBegin input) {
        boolean usesUnboundedFeatures;
        boolean isRangeUnbounded = this.getTo() < 0L;
        boolean bl = usesUnboundedFeatures = this.getTimestampFn() != null || this.getElementsPerPeriod() > 0L || this.getMaxReadTime() != null;
        if (!isRangeUnbounded && !usesUnboundedFeatures) {
            return (PCollection)input.apply(Read.from(CountingSource.createSourceForSubrange(this.getFrom(), this.getTo())));
        }
        CountingSource.UnboundedCountingSource source = CountingSource.createUnboundedFrom(this.getFrom());
        if (this.getTimestampFn() != null) {
            source = source.withTimestampFn(this.getTimestampFn());
        }
        if (this.getElementsPerPeriod() > 0L) {
            source = source.withRate(this.getElementsPerPeriod(), this.getPeriod());
        }
        Read.Unbounded<Long> readUnbounded = Read.from(source);
        if (this.getMaxReadTime() == null) {
            if (isRangeUnbounded) {
                return (PCollection)input.apply(readUnbounded);
            }
            return (PCollection)input.apply(readUnbounded.withMaxNumRecords(this.getTo() - this.getFrom()));
        }
        BoundedReadFromUnboundedSource<Long> withMaxReadTime = readUnbounded.withMaxReadTime(this.getMaxReadTime());
        if (isRangeUnbounded) {
            return (PCollection)input.apply(withMaxReadTime);
        }
        return (PCollection)input.apply(withMaxReadTime.withMaxNumRecords(this.getTo() - this.getFrom()));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        builder.add(DisplayData.item("from", this.getFrom()).withLabel("Generate sequence from"));
        builder.addIfNotDefault(DisplayData.item("to", this.getTo()).withLabel("Generate sequence to (exclusive)"), -1L);
        builder.addIfNotNull(DisplayData.item("timestampFn", this.getTimestampFn() == null ? null : this.getTimestampFn().getClass()).withLabel("Timestamp Function"));
        builder.addIfNotNull(DisplayData.item("maxReadTime", this.getMaxReadTime()).withLabel("Maximum Read Time"));
        if (this.getElementsPerPeriod() > 0L) {
            builder.add(DisplayData.item("elementsPerPeriod", this.getElementsPerPeriod()).withLabel("Elements per period"));
            builder.add(DisplayData.item("period", this.getPeriod()).withLabel("Period"));
        }
    }

    @Experimental
    public static class External
    implements ExternalTransformRegistrar {
        public static final String URN = "beam:external:java:generate_sequence:v1";

        @Override
        public Map<String, Class<? extends ExternalTransformBuilder<?, ?, ?>>> knownBuilders() {
            return ImmutableMap.of((Object)URN, AutoValue_GenerateSequence.Builder.class);
        }

        @Experimental
        public static class ExternalConfiguration {
            private Long start;
            private @Nullable Long stop;
            private @Nullable Long period;
            private @Nullable Long maxReadTime;
            private @Nullable Long elementsPerPeriod;

            public void setStart(Long start) {
                this.start = start;
            }

            public void setStop(@Nullable Long stop) {
                this.stop = stop;
            }

            public void setPeriod(@Nullable Long period) {
                this.period = period;
            }

            public void setMaxReadTime(@Nullable Long maxReadTime) {
                this.maxReadTime = maxReadTime;
            }

            public void setElementsPerPeriod(@Nullable Long elementsPerPeriod) {
                this.elementsPerPeriod = elementsPerPeriod;
            }
        }
    }

    @AutoValue.Builder
    @Experimental
    static abstract class Builder
    implements ExternalTransformBuilder<External.ExternalConfiguration, PBegin, PCollection<Long>> {
        Builder() {
        }

        abstract Builder setFrom(long var1);

        abstract Builder setTo(long var1);

        abstract Builder setTimestampFn(SerializableFunction<Long, Instant> var1);

        abstract Builder setElementsPerPeriod(long var1);

        abstract Builder setPeriod(Duration var1);

        abstract Builder setMaxReadTime(Duration var1);

        abstract GenerateSequence build();

        public GenerateSequence buildExternal(External.ExternalConfiguration config) {
            Preconditions.checkNotNull((Object)config.start, (Object)"Parameters 'from' must not be null.");
            this.setFrom(config.start);
            this.setTo(-1L);
            this.setElementsPerPeriod(0L);
            if (config.stop != null) {
                this.setTo(config.stop);
            }
            if (config.period != null) {
                this.setPeriod(Duration.millis((long)config.period));
            }
            if (config.maxReadTime != null) {
                this.setMaxReadTime(Duration.millis((long)config.maxReadTime));
            }
            if (config.elementsPerPeriod != null) {
                this.setElementsPerPeriod(config.elementsPerPeriod);
            }
            return this.build();
        }
    }
}

