/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.Row;

@Internal
public class AvroSchemaIOProvider
implements SchemaIOProvider {
    @Override
    public String identifier() {
        return "avro";
    }

    @Override
    public Schema configurationSchema() {
        return Schema.builder().build();
    }

    @Override
    public AvroSchemaIO from(String location, Row configuration, Schema dataSchema) {
        return new AvroSchemaIO(location, dataSchema);
    }

    @Override
    public boolean requiresDataSchema() {
        return true;
    }

    @Override
    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    private static class AvroSchemaIO
    implements SchemaIO,
    Serializable {
        protected final Schema dataSchema;
        protected final String location;

        private AvroSchemaIO(String location, Schema dataSchema) {
            this.dataSchema = dataSchema;
            this.location = location;
        }

        @Override
        public Schema schema() {
            return this.dataSchema;
        }

        @Override
        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                @Override
                public PCollection<Row> expand(PBegin begin) {
                    return ((PCollection)begin.apply("AvroIORead", AvroIO.readGenericRecords(AvroUtils.toAvroSchema(dataSchema, null, null)).withBeamSchemas(true).from(location))).apply("ToRows", Convert.toRows());
                }
            };
        }

        public PTransform<PCollection<Row>, POutput> buildWriter() {
            return new PTransform<PCollection<Row>, POutput>(){

                @Override
                public PDone expand(PCollection<Row> input) {
                    return (PDone)input.apply("ToGenericRecords", Convert.to(GenericRecord.class)).apply("AvroIOWrite", AvroIO.writeGenericRecords(AvroUtils.toAvroSchema(dataSchema, null, null)).to(location).withoutSharding());
                }
            };
        }
    }
}

