/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.util.Arrays;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.TextIO;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_TextIO_ReadAll
extends TextIO.ReadAll {
    private final FileIO.MatchConfiguration matchConfiguration;
    private final Compression compression;
    private final byte @Nullable [] delimiter;

    private AutoValue_TextIO_ReadAll(FileIO.MatchConfiguration matchConfiguration, Compression compression, byte @Nullable [] delimiter) {
        this.matchConfiguration = matchConfiguration;
        this.compression = compression;
        this.delimiter = delimiter;
    }

    @Override
    FileIO.MatchConfiguration getMatchConfiguration() {
        return this.matchConfiguration;
    }

    @Override
    Compression getCompression() {
        return this.compression;
    }

    @Override
    byte @Nullable [] getDelimiter() {
        return this.delimiter;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TextIO.ReadAll) {
            TextIO.ReadAll that = (TextIO.ReadAll)o;
            return this.matchConfiguration.equals(that.getMatchConfiguration()) && this.compression.equals((Object)that.getCompression()) && Arrays.equals(this.delimiter, that instanceof AutoValue_TextIO_ReadAll ? ((AutoValue_TextIO_ReadAll)that).delimiter : that.getDelimiter());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.matchConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.compression.hashCode();
        h$ *= 1000003;
        return h$ ^= Arrays.hashCode(this.delimiter);
    }

    @Override
    TextIO.ReadAll.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TextIO.ReadAll.Builder {
        private FileIO.MatchConfiguration matchConfiguration;
        private Compression compression;
        private byte @Nullable [] delimiter;

        Builder() {
        }

        private Builder(TextIO.ReadAll source) {
            this.matchConfiguration = source.getMatchConfiguration();
            this.compression = source.getCompression();
            this.delimiter = source.getDelimiter();
        }

        @Override
        TextIO.ReadAll.Builder setMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            if (matchConfiguration == null) {
                throw new NullPointerException("Null matchConfiguration");
            }
            this.matchConfiguration = matchConfiguration;
            return this;
        }

        @Override
        TextIO.ReadAll.Builder setCompression(Compression compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        TextIO.ReadAll.Builder setDelimiter(byte @Nullable [] delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        @Override
        TextIO.ReadAll build() {
            String missing = "";
            if (this.matchConfiguration == null) {
                missing = missing + " matchConfiguration";
            }
            if (this.compression == null) {
                missing = missing + " compression";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TextIO_ReadAll(this.matchConfiguration, this.compression, this.delimiter);
        }
    }
}

