/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.TFRecordIO;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_TFRecordIO_Read
extends TFRecordIO.Read {
    private final @Nullable ValueProvider<String> filepattern;
    private final boolean validate;
    private final Compression compression;

    private AutoValue_TFRecordIO_Read(@Nullable ValueProvider<String> filepattern, boolean validate, Compression compression) {
        this.filepattern = filepattern;
        this.validate = validate;
        this.compression = compression;
    }

    @Override
    @Nullable ValueProvider<String> getFilepattern() {
        return this.filepattern;
    }

    @Override
    boolean getValidate() {
        return this.validate;
    }

    @Override
    Compression getCompression() {
        return this.compression;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TFRecordIO.Read) {
            TFRecordIO.Read that = (TFRecordIO.Read)o;
            return (this.filepattern == null ? that.getFilepattern() == null : this.filepattern.equals(that.getFilepattern())) && this.validate == that.getValidate() && this.compression.equals((Object)that.getCompression());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.filepattern == null ? 0 : this.filepattern.hashCode();
        h$ *= 1000003;
        h$ ^= this.validate ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.compression.hashCode();
    }

    @Override
    TFRecordIO.Read.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends TFRecordIO.Read.Builder {
        private @Nullable ValueProvider<String> filepattern;
        private Boolean validate;
        private Compression compression;

        Builder() {
        }

        private Builder(TFRecordIO.Read source) {
            this.filepattern = source.getFilepattern();
            this.validate = source.getValidate();
            this.compression = source.getCompression();
        }

        @Override
        TFRecordIO.Read.Builder setFilepattern(ValueProvider<String> filepattern) {
            this.filepattern = filepattern;
            return this;
        }

        @Override
        TFRecordIO.Read.Builder setValidate(boolean validate) {
            this.validate = validate;
            return this;
        }

        @Override
        TFRecordIO.Read.Builder setCompression(Compression compression) {
            if (compression == null) {
                throw new NullPointerException("Null compression");
            }
            this.compression = compression;
            return this;
        }

        @Override
        TFRecordIO.Read build() {
            String missing = "";
            if (this.validate == null) {
                missing = missing + " validate";
            }
            if (this.compression == null) {
                missing = missing + " compression";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TFRecordIO_Read(this.filepattern, this.validate, this.compression);
        }
    }
}

