/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_AvroIO_ParseFiles<T>
extends AvroIO.ParseFiles<T> {
    private final SerializableFunction<GenericRecord, T> parseFn;
    private final @Nullable Coder<T> coder;
    private final long desiredBundleSizeBytes;

    private AutoValue_AvroIO_ParseFiles(SerializableFunction<GenericRecord, T> parseFn, @Nullable Coder<T> coder, long desiredBundleSizeBytes) {
        this.parseFn = parseFn;
        this.coder = coder;
        this.desiredBundleSizeBytes = desiredBundleSizeBytes;
    }

    @Override
    SerializableFunction<GenericRecord, T> getParseFn() {
        return this.parseFn;
    }

    @Override
    @Nullable Coder<T> getCoder() {
        return this.coder;
    }

    @Override
    long getDesiredBundleSizeBytes() {
        return this.desiredBundleSizeBytes;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AvroIO.ParseFiles) {
            AvroIO.ParseFiles that = (AvroIO.ParseFiles)o;
            return this.parseFn.equals(that.getParseFn()) && (this.coder == null ? that.getCoder() == null : this.coder.equals(that.getCoder())) && this.desiredBundleSizeBytes == that.getDesiredBundleSizeBytes();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.parseFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.coder == null ? 0 : this.coder.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(this.desiredBundleSizeBytes >>> 32 ^ this.desiredBundleSizeBytes);
    }

    @Override
    AvroIO.ParseFiles.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends AvroIO.ParseFiles.Builder<T> {
        private SerializableFunction<GenericRecord, T> parseFn;
        private @Nullable Coder<T> coder;
        private Long desiredBundleSizeBytes;

        Builder() {
        }

        private Builder(AvroIO.ParseFiles<T> source) {
            this.parseFn = source.getParseFn();
            this.coder = source.getCoder();
            this.desiredBundleSizeBytes = source.getDesiredBundleSizeBytes();
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setParseFn(SerializableFunction<GenericRecord, T> parseFn) {
            if (parseFn == null) {
                throw new NullPointerException("Null parseFn");
            }
            this.parseFn = parseFn;
            return this;
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setCoder(Coder<T> coder) {
            this.coder = coder;
            return this;
        }

        @Override
        AvroIO.ParseFiles.Builder<T> setDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            this.desiredBundleSizeBytes = desiredBundleSizeBytes;
            return this;
        }

        @Override
        AvroIO.ParseFiles<T> build() {
            String missing = "";
            if (this.parseFn == null) {
                missing = missing + " parseFn";
            }
            if (this.desiredBundleSizeBytes == null) {
                missing = missing + " desiredBundleSizeBytes";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AvroIO_ParseFiles(this.parseFn, this.coder, this.desiredBundleSizeBytes);
        }
    }
}

