/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;

public class SetCoder<T>
extends IterableLikeCoder<T, Set<T>> {
    public static <T> SetCoder<T> of(Coder<T> elementCoder) {
        return new SetCoder<T>(elementCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Ordering of elements in a set may be non-deterministic.");
    }

    @Override
    public TypeDescriptor<Set<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<Set<T>>(){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }

    @Override
    protected final Set<T> decodeToIterable(List<T> decodedElements) {
        return new HashSet<T>(decodedElements);
    }

    protected SetCoder(Coder<T> elemCoder) {
        super(elemCoder, "Set");
    }
}

