/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableLikeCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;

public class DequeCoder<T>
extends IterableLikeCoder<T, Deque<T>> {
    public static <T> DequeCoder<T> of(Coder<T> elemCoder) {
        return new DequeCoder<T>(elemCoder);
    }

    @Override
    protected Deque<T> decodeToIterable(List<T> decodedElements) {
        return new ArrayDeque<T>(decodedElements);
    }

    protected DequeCoder(Coder<T> elemCoder) {
        super(elemCoder, "Deque");
    }

    @Override
    public boolean consistentWithEquals() {
        return this.getElemCoder().consistentWithEquals();
    }

    @Override
    public Object structuralValue(Deque<T> values) {
        if (this.consistentWithEquals()) {
            return values;
        }
        ArrayDeque<Object> ret = new ArrayDeque<Object>(values.size());
        for (T value : values) {
            ret.add(this.getElemCoder().structuralValue(value));
        }
        return ret;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        DequeCoder.verifyDeterministic(this, "Coder for elements of DequeCoder must be determistic", this.getElemCoder());
    }

    @Override
    public TypeDescriptor<Deque<T>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<Deque<T>>(this.getClass()){}.where(new TypeParameter<T>(){}, this.getElemCoder().getEncodedTypeDescriptor());
    }
}

