/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.values.TypeDescriptor;

public class BigEndianShortCoder
extends AtomicCoder<Short> {
    private static final BigEndianShortCoder INSTANCE = new BigEndianShortCoder();
    private static final TypeDescriptor<Short> TYPE_DESCRIPTOR = new TypeDescriptor<Short>(){};

    public static BigEndianShortCoder of() {
        return INSTANCE;
    }

    private BigEndianShortCoder() {
    }

    @Override
    public void encode(Short value, OutputStream outStream) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null Short");
        }
        new DataOutputStream(outStream).writeShort(value.shortValue());
    }

    @Override
    public Short decode(InputStream inStream) throws IOException, CoderException {
        try {
            return new DataInputStream(inStream).readShort();
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Short value) {
        return true;
    }

    @Override
    public TypeDescriptor<Short> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }

    @Override
    protected long getEncodedElementByteSize(Short value) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Short");
        }
        return 2L;
    }
}

