/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.io.aws.s3.S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws.s3.S3ResourceId;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class S3WritableByteChannel
implements WritableByteChannel {
    private final AmazonS3 amazonS3;
    private final S3FileSystemConfiguration config;
    private final S3ResourceId path;
    private final String uploadId;
    private final ByteBuffer uploadBuffer;
    private final List<PartETag> eTags;
    private int partNumber = 1;
    private boolean open = true;
    private final MessageDigest md5 = S3WritableByteChannel.md5();

    S3WritableByteChannel(AmazonS3 amazonS3, S3ResourceId path, String contentType, S3FileSystemConfiguration config) throws IOException {
        InitiateMultipartUploadResult result;
        this.amazonS3 = (AmazonS3)Preconditions.checkNotNull((Object)amazonS3, (Object)"amazonS3");
        this.config = (S3FileSystemConfiguration)Preconditions.checkNotNull((Object)config);
        this.path = (S3ResourceId)Preconditions.checkNotNull((Object)path, (Object)"path");
        Preconditions.checkArgument((boolean)S3WritableByteChannel.atMostOne(config.getSSECustomerKey() != null, config.getSSEAlgorithm() != null, config.getSSEAwsKeyManagementParams() != null), (Object)"Either SSECustomerKey (SSE-C) or SSEAlgorithm (SSE-S3) or SSEAwsKeyManagementParams (SSE-KMS) must not be set at the same time.");
        Preconditions.checkArgument((config.getS3UploadBufferSizeBytes() >= 0x500000 ? 1 : 0) != 0, (String)"S3UploadBufferSizeBytes must be at least %s bytes", (int)0x500000);
        this.uploadBuffer = ByteBuffer.allocate(config.getS3UploadBufferSizeBytes());
        this.eTags = new ArrayList<PartETag>();
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentType(contentType);
        if (config.getSSEAlgorithm() != null) {
            objectMetadata.setSSEAlgorithm(config.getSSEAlgorithm());
        }
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(path.getBucket(), path.getKey()).withStorageClass(config.getS3StorageClass()).withObjectMetadata(objectMetadata);
        request.setSSECustomerKey(config.getSSECustomerKey());
        request.setSSEAwsKeyManagementParams(config.getSSEAwsKeyManagementParams());
        try {
            result = amazonS3.initiateMultipartUpload(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        this.uploadId = result.getUploadId();
    }

    private static MessageDigest md5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int write(ByteBuffer sourceBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        int totalBytesWritten = 0;
        while (sourceBuffer.hasRemaining()) {
            int bytesWritten = Math.min(sourceBuffer.remaining(), this.uploadBuffer.remaining());
            totalBytesWritten += bytesWritten;
            byte[] copyBuffer = new byte[bytesWritten];
            sourceBuffer.get(copyBuffer);
            this.uploadBuffer.put(copyBuffer);
            this.md5.update(copyBuffer);
            if (this.uploadBuffer.hasRemaining() && !sourceBuffer.hasRemaining()) continue;
            this.flush();
        }
        return totalBytesWritten;
    }

    private void flush() throws IOException {
        UploadPartResult result;
        this.uploadBuffer.flip();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.uploadBuffer.array());
        UploadPartRequest request = new UploadPartRequest().withBucketName(this.path.getBucket()).withKey(this.path.getKey()).withUploadId(this.uploadId).withPartNumber(this.partNumber++).withPartSize((long)this.uploadBuffer.remaining()).withMD5Digest(Base64.encodeAsString((byte[])this.md5.digest())).withInputStream((InputStream)inputStream);
        request.setSSECustomerKey(this.config.getSSECustomerKey());
        try {
            result = this.amazonS3.uploadPart(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
        this.uploadBuffer.clear();
        this.md5.reset();
        this.eTags.add(result.getPartETag());
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        if (this.uploadBuffer.remaining() > 0) {
            this.flush();
        }
        CompleteMultipartUploadRequest request = new CompleteMultipartUploadRequest().withBucketName(this.path.getBucket()).withKey(this.path.getKey()).withUploadId(this.uploadId).withPartETags(this.eTags);
        try {
            this.amazonS3.completeMultipartUpload(request);
        }
        catch (AmazonClientException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    static boolean atMostOne(boolean ... values) {
        boolean one = false;
        for (boolean value : values) {
            if (!one && value) {
                one = true;
                continue;
            }
            if (!value) continue;
            return false;
        }
        return true;
    }
}

