/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.s3;

import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.aws.options.S3ClientBuilderFactory;
import org.apache.beam.sdk.io.aws.options.S3Options;
import org.apache.beam.sdk.io.aws.s3.AutoValue_S3FileSystemConfiguration;
import org.apache.beam.sdk.util.InstanceBuilder;

@AutoValue
@Experimental(value=Experimental.Kind.FILESYSTEM)
public abstract class S3FileSystemConfiguration {
    public static final int MINIMUM_UPLOAD_BUFFER_SIZE_BYTES = 0x500000;

    public abstract String getScheme();

    public abstract String getS3StorageClass();

    public abstract int getS3UploadBufferSizeBytes();

    public abstract int getS3ThreadPoolSize();

    @Nullable
    public abstract String getSSEAlgorithm();

    @Nullable
    public abstract SSECustomerKey getSSECustomerKey();

    @Nullable
    public abstract SSEAwsKeyManagementParams getSSEAwsKeyManagementParams();

    public abstract AmazonS3ClientBuilder getS3ClientBuilder();

    public static Builder builder() {
        return new AutoValue_S3FileSystemConfiguration.Builder();
    }

    public abstract Builder toBuilder();

    public static Builder fromS3Options(S3Options s3Options) {
        return S3FileSystemConfiguration.builder().setScheme("s3").setS3StorageClass(s3Options.getS3StorageClass()).setS3UploadBufferSizeBytes(s3Options.getS3UploadBufferSizeBytes()).setS3ThreadPoolSize(s3Options.getS3ThreadPoolSize()).setSSEAlgorithm(s3Options.getSSEAlgorithm()).setSSECustomerKey(s3Options.getSSECustomerKey()).setSSEAwsKeyManagementParams(s3Options.getSSEAwsKeyManagementParams()).setS3ClientBuilder(S3FileSystemConfiguration.getBuilder(s3Options));
    }

    public static AmazonS3ClientBuilder getBuilder(S3Options s3Options) {
        return ((S3ClientBuilderFactory)InstanceBuilder.ofType(S3ClientBuilderFactory.class).fromClass(s3Options.getS3ClientFactoryClass()).build()).createBuilder(s3Options);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setScheme(String var1);

        public abstract Builder setS3StorageClass(String var1);

        public abstract Builder setS3UploadBufferSizeBytes(int var1);

        public abstract Builder setS3ThreadPoolSize(int var1);

        public abstract Builder setSSEAlgorithm(@Nullable String var1);

        public abstract Builder setSSECustomerKey(@Nullable SSECustomerKey var1);

        public abstract Builder setSSEAwsKeyManagementParams(@Nullable SSEAwsKeyManagementParams var1);

        public abstract Builder setS3ClientBuilder(AmazonS3ClientBuilder var1);

        public abstract S3FileSystemConfiguration build();
    }
}

