/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.server.HttpUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopServerWorkflowStatus {
    public static final String XML_TAG = "workflow-status";
    private String workflowName;
    private String id;
    private String statusDescription;
    private String errorDescription;
    private String loggingString;
    private int firstLoggingLineNr;
    private int lastLoggingLineNr;
    private Date logDate;
    private Result result;

    public HopServerWorkflowStatus() {
    }

    public HopServerWorkflowStatus(String pipelineName, String id, String statusDescription) {
        this();
        this.workflowName = pipelineName;
        this.id = id;
        this.statusDescription = statusDescription;
    }

    @JsonIgnore
    public String getXml() throws HopException {
        boolean sendResultXmlWithStatus = EnvUtil.getSystemProperty((String)"HOP_COMPATIBILITY_SEND_RESULT_XML_WITH_FULL_STATUS", (String)"N").equalsIgnoreCase("Y");
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("  ").append(XmlHandler.addTagValue((String)"workflowname", (String)this.workflowName));
        xml.append("  ").append(XmlHandler.addTagValue((String)"id", (String)this.id));
        xml.append("  ").append(XmlHandler.addTagValue((String)"status_desc", (String)this.statusDescription));
        xml.append("  ").append(XmlHandler.addTagValue((String)"error_desc", (String)this.errorDescription));
        xml.append("  ").append(XmlHandler.addTagValue((String)"log_date", (String)XmlHandler.date2string((Date)this.logDate)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"logging_string", (String)XmlHandler.buildCDATA((String)this.loggingString)));
        xml.append("  ").append(XmlHandler.addTagValue((String)"first_log_line_nr", (int)this.firstLoggingLineNr));
        xml.append("  ").append(XmlHandler.addTagValue((String)"last_log_line_nr", (int)this.lastLoggingLineNr));
        if (this.result != null) {
            String resultXML = sendResultXmlWithStatus ? this.result.getXml() : this.result.getBasicXml();
            xml.append(resultXML);
        }
        xml.append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public HopServerWorkflowStatus(Node workflowStatusNode) throws HopException {
        this();
        Node resultNode;
        this.workflowName = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"workflowname");
        this.id = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"id");
        this.statusDescription = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"status_desc");
        this.errorDescription = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"error_desc");
        this.logDate = XmlHandler.stringToDate((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)"log_date"));
        this.firstLoggingLineNr = Const.toInt((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)"first_log_line_nr"), (int)0);
        this.lastLoggingLineNr = Const.toInt((String)XmlHandler.getTagValue((Node)workflowStatusNode, (String)"last_log_line_nr"), (int)0);
        String loggingString64 = XmlHandler.getTagValue((Node)workflowStatusNode, (String)"logging_string");
        if (!Utils.isEmpty((CharSequence)loggingString64)) {
            String dataString64 = loggingString64.substring("<![CDATA[".length(), loggingString64.length() - "]]>".length());
            try {
                this.loggingString = HttpUtil.decodeBase64ZippedString((String)dataString64);
            }
            catch (IOException e) {
                this.loggingString = "Unable to decode logging from remote server : " + e.toString() + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e);
            }
        } else {
            this.loggingString = "";
        }
        if ((resultNode = XmlHandler.getSubNode((Node)workflowStatusNode, (String)"result")) != null) {
            try {
                this.result = new Result(resultNode);
            }
            catch (HopException e) {
                this.loggingString = this.loggingString + "Unable to serialize result object as XML" + Const.CR + Const.getSimpleStackTrace((Throwable)e) + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
            }
        }
    }

    public static HopServerWorkflowStatus fromXml(String xml) throws HopException {
        Document document = XmlHandler.loadXmlString((String)xml);
        HopServerWorkflowStatus status = new HopServerWorkflowStatus(XmlHandler.getSubNode((Node)document, (String)XML_TAG));
        return status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getLoggingString() {
        return this.loggingString;
    }

    public void setLoggingString(String loggingString) {
        this.loggingString = loggingString;
    }

    public boolean isRunning() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Running") || this.getStatusDescription().equalsIgnoreCase("Initializing");
    }

    public boolean isWaiting() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Waiting");
    }

    public boolean isFinished() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Finished") || this.getStatusDescription().equalsIgnoreCase("Finished (with errors)");
    }

    public boolean isStopped() {
        if (this.getStatusDescription() == null) {
            return false;
        }
        return this.getStatusDescription().equalsIgnoreCase("Stopped") || this.getStatusDescription().equalsIgnoreCase("Stopped (with errors)");
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public int getFirstLoggingLineNr() {
        return this.firstLoggingLineNr;
    }

    public void setFirstLoggingLineNr(int firstLoggingLineNr) {
        this.firstLoggingLineNr = firstLoggingLineNr;
    }

    public int getLastLoggingLineNr() {
        return this.lastLoggingLineNr;
    }

    public void setLastLoggingLineNr(int lastLoggingLineNr) {
        this.lastLoggingLineNr = lastLoggingLineNr;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

