/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerSingleton;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebServer;
import org.apache.hop.www.WorkflowMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopServer {
    private static final Class<?> PKG = HopServer.class;
    private WebServer webServer;
    private HopServerConfig config;
    private boolean allOK;
    private static Options options;

    public HopServer(HopServerConfig config) throws Exception {
        this(config, null);
    }

    public HopServer(HopServerConfig config, Boolean joinOverride) throws Exception {
        this.config = config;
        this.allOK = true;
        HopServerSingleton.setHopServerConfig(config);
        ILogChannel log = HopServerSingleton.getInstance().getLog();
        PipelineMap pipelineMap = HopServerSingleton.getInstance().getPipelineMap();
        pipelineMap.setHopServerConfig(config);
        WorkflowMap workflowMap = HopServerSingleton.getInstance().getWorkflowMap();
        workflowMap.setHopServerConfig(config);
        org.apache.hop.server.HopServer hopServer = config.getHopServer();
        String hostname = hopServer.getHostname();
        int port = 80;
        if (!Utils.isEmpty((CharSequence)hopServer.getPort())) {
            try {
                port = Integer.parseInt(hopServer.getPort());
            }
            catch (Exception e) {
                log.logError(BaseMessages.getString(PKG, (String)"HopServer.Error.CanNotPartPort", (String[])new String[]{hopServer.getHostname(), "" + port}), (Throwable)e);
                this.allOK = false;
            }
        }
        if (this.allOK) {
            boolean shouldJoin = config.isJoining();
            if (joinOverride != null) {
                shouldJoin = joinOverride;
            }
            this.webServer = new WebServer(log, pipelineMap, workflowMap, hostname, port, shouldJoin, config.getPasswordFile(), hopServer.getSslConfig());
        }
    }

    public static void main(String[] args) {
        try {
            HopServer.parseAndRunCommand(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseAndRunCommand(String[] args) throws Exception {
        options = new Options();
        OptionBuilder.withLongOpt((String)"stop");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"HopServer.ParamDescription.stop", (String[])new String[0]));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"userName");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"HopServer.ParamDescription.userName", (String[])new String[0]));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'u'));
        OptionBuilder.withLongOpt((String)"password");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"HopServer.ParamDescription.password", (String[])new String[0]));
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.isRequired((boolean)false);
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)BaseMessages.getString(PKG, (String)"HopServer.ParamDescription.help", (String[])new String[0]));
        options.addOption(OptionBuilder.create((char)'h'));
        BasicParser parser = new BasicParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption('h')) {
            HopServer.displayHelpAndAbort();
        }
        String[] arguments = cmd.getArgs();
        boolean usingConfigFile = false;
        HopServerConfig config = null;
        if (arguments.length == 1 && !Utils.isEmpty((CharSequence)arguments[0])) {
            if (cmd.hasOption('s')) {
                throw new HopServerCommandException(BaseMessages.getString(PKG, (String)"HopServer.Error.illegalStop", (String[])new String[0]));
            }
            usingConfigFile = true;
            FileObject file = HopVfs.getFileObject((String)arguments[0]);
            Document document = XmlHandler.loadXmlFile((FileObject)file);
            HopServer.setHopEnvironment();
            Node configNode = XmlHandler.getSubNode((Node)document, (String)"hop-server-config");
            config = new HopServerConfig((ILogChannel)new LogChannel((Object)"Hop server config"), configNode);
            if (config.getAutoSequence() != null) {
                config.readAutoSequences();
            }
            config.setFilename(arguments[0]);
        }
        if (arguments.length == 2 && !Utils.isEmpty((CharSequence)arguments[0]) && !Utils.isEmpty((CharSequence)arguments[1])) {
            String hostname = arguments[0];
            String port = arguments[1];
            if (cmd.hasOption('s')) {
                String user = cmd.getOptionValue('u');
                String password = cmd.getOptionValue('p');
                HopServer.shutdown(hostname, port, user, password);
                System.exit(0);
            }
            org.apache.hop.server.HopServer hopServer = new org.apache.hop.server.HopServer(hostname + ":" + port, hostname, port, null, null);
            config = new HopServerConfig();
            config.setHopServer(hopServer);
        }
        if (config == null) {
            HopServer.displayHelpAndAbort();
        }
        if (!usingConfigFile) {
            HopServer.setHopEnvironment();
        }
        HopServer.runHopServer(config);
    }

    private static void setHopEnvironment() throws Exception {
        HopClientEnvironment.getInstance().setClient(HopClientEnvironment.ClientType.SERVER);
        HopEnvironment.init();
    }

    public static void runHopServer(HopServerConfig config) throws Exception {
        HopLogStore.init();
        config.setJoining(true);
        HopServer hopServer = new HopServer(config, false);
        HopServerSingleton.setHopServer(hopServer);
        hopServer.getWebServer().join();
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    public HopServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(HopServerConfig config) {
        this.config = config;
    }

    private static void displayHelpAndAbort() {
        HelpFormatter formatter = new HelpFormatter();
        String optionsHelp = HopServer.getOptionsHelpForUsage();
        String header = BaseMessages.getString(PKG, (String)"HopServer.Usage.Text", (String[])new String[0]) + optionsHelp + "\nor\n" + BaseMessages.getString(PKG, (String)"HopServer.Usage.Text2", (String[])new String[0]) + "\n\n" + BaseMessages.getString(PKG, (String)"HopServer.MainDescription", (String[])new String[0]);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        formatter.printHelp(printWriter, 80, "HopServerDummy", header, options, 5, 5, "", false);
        System.err.println(HopServer.stripOff(stringWriter.toString(), "usage: HopServerDummy"));
        System.err.println(BaseMessages.getString(PKG, (String)"HopServer.Usage.Example", (String[])new String[0]) + ": hop-server.sh 127.0.0.1 8080");
        System.err.println(BaseMessages.getString(PKG, (String)"HopServer.Usage.Example", (String[])new String[0]) + ": hop-server.sh 192.168.1.221 8081");
        System.err.println();
        System.err.println(BaseMessages.getString(PKG, (String)"HopServer.Usage.Example", (String[])new String[0]) + ": hop-server.sh /foo/bar/hop-server-config.xml");
        System.err.println(BaseMessages.getString(PKG, (String)"HopServer.Usage.Example", (String[])new String[0]) + ": hop-server.sh http://www.example.com/hop-server-config.xml");
        System.err.println(BaseMessages.getString(PKG, (String)"HopServer.Usage.Example", (String[])new String[0]) + ": hop-server.sh 127.0.0.1 8080 -s -u cluster -p cluster");
        System.exit(1);
    }

    private static String getOptionsHelpForUsage() {
        HelpFormatter formatter = new HelpFormatter();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        formatter.printUsage(printWriter, 999, "", options);
        return HopServer.stripOff(stringWriter.toString(), "usage: ");
    }

    private static String stripOff(String target, String strip) {
        return target.substring(target.indexOf(strip) + strip.length());
    }

    private static void shutdown(String hostname, String port, String username, String password) {
        try {
            HopServer.callStopHopServerRestService(hostname, port, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    static void callStopHopServerRestService(String hostname, String port, String username, String password) throws ParseException, HopServerCommandException {
        try {
            HopClientEnvironment.init();
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
            Client client = Client.create((ClientConfig)clientConfig);
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, Encr.decryptPasswordOptionallyEncrypted((String)password)));
            String contextURL = "http://" + hostname + ":" + port + "/hop";
            WebResource resource = client.resource(contextURL + "/status/?xml=Y");
            String response = (String)resource.get(String.class);
            if (response == null || !response.contains("<serverstatus>")) {
                throw new HopServerCommandException(BaseMessages.getString(PKG, (String)"HopServer.Error.NoServerFound", (String[])new String[]{hostname, "" + port}));
            }
            resource = client.resource(contextURL + "/stopHopServer");
            response = (String)resource.get(String.class);
            if (response == null || !response.contains("Shutting Down")) {
                throw new HopServerCommandException(BaseMessages.getString(PKG, (String)"HopServer.Error.NoShutdown", (String[])new String[]{hostname, "" + port}));
            }
        }
        catch (Exception e) {
            throw new HopServerCommandException(BaseMessages.getString(PKG, (String)"HopServer.Error.NoServerFound", (String[])new String[]{hostname, "" + port}), e);
        }
    }

    public static class HopServerCommandException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HopServerCommandException() {
        }

        public HopServerCommandException(String message) {
            super(message);
        }

        public HopServerCommandException(String message, Throwable cause) {
            super(message, cause);
        }

        public HopServerCommandException(Throwable cause) {
            super(cause);
        }
    }
}

