/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.engines.remote;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.WorkflowTracker;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.IExecutionFinishedListener;
import org.apache.hop.pipeline.IExecutionStartedListener;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.remote.RemotePipelineEngine;
import org.apache.hop.resource.ResourceUtil;
import org.apache.hop.resource.TopLevelResource;
import org.apache.hop.server.HopServer;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.IActionListener;
import org.apache.hop.workflow.IDelegationListener;
import org.apache.hop.workflow.Workflow;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEnginePlugin;
import org.apache.hop.workflow.engines.remote.RemoteWorkflowRunConfiguration;
import org.apache.hop.www.HopServerWorkflowStatus;
import org.apache.hop.www.WebResult;

@WorkflowEnginePlugin(id="Remote", name="Hop remote workflow engine", description="Executes your workflow on a remote hop server")
public class RemoteWorkflowEngine
extends Variables
implements IWorkflowEngine<WorkflowMeta> {
    private static final Class<?> PKG = Workflow.class;
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__workflow_execution_configuration__.xml";
    protected WorkflowMeta workflowMeta;
    protected String pluginId;
    protected WorkflowRunConfiguration workflowRunConfiguration;
    protected RemoteWorkflowRunConfiguration remoteWorkflowRunConfiguration;
    protected Result previousResult;
    protected Result result;
    protected IHopMetadataProvider metadataProvider;
    protected ILogChannel logChannel;
    protected LoggingObject loggingObject;
    protected LogLevel logLevel;
    protected long serverPollDelay;
    protected long serverPollInterval;
    protected HopServer hopServer;
    protected String containerId;
    protected int lastLogLineNr;
    protected boolean stopped;
    protected HopServerWorkflowStatus workflowStatus;
    protected boolean interactive;
    protected boolean finished;
    protected boolean initialized;
    protected boolean running;
    protected boolean active;
    protected String statusDescription;
    protected boolean gatheringMetrics;
    protected boolean forcingSeparateLogging;
    protected Date executionStartDate;
    protected Date executionEndDate;
    protected List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> workflowFinishedListeners;
    protected List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> workflowStartedListeners;
    protected List<IActionListener> actionListeners;
    protected List<IDelegationListener> delegationListeners;
    protected Set<ActionMeta> activeActions;
    protected Map<String, Object> extensionDataMap;
    private List<RowMetaAndData> sourceRows;
    private INamedParameters namedParams = new NamedParameters();
    private ActionMeta startActionMeta;
    protected IWorkflowEngine<WorkflowMeta> parentWorkflow;
    protected IPipelineEngine parentPipeline;
    private ILoggingObject parentLoggingObject;
    private WorkflowTracker workflowTracker;
    private final LinkedList<ActionResult> actionResults = new LinkedList();

    public RemoteWorkflowEngine() {
        this.workflowStartedListeners = Collections.synchronizedList(new ArrayList());
        this.workflowFinishedListeners = Collections.synchronizedList(new ArrayList());
        this.actionListeners = new ArrayList<IActionListener>();
        this.activeActions = Collections.synchronizedSet(new HashSet());
        this.extensionDataMap = new HashMap<String, Object>();
        this.logChannel = LogChannel.GENERAL;
        this.logLevel = LogLevel.BASIC;
    }

    @Override
    public IWorkflowEngineRunConfiguration createDefaultWorkflowEngineRunConfiguration() {
        return new RemoteWorkflowRunConfiguration();
    }

    @Override
    public void setInternalHopVariables() {
        if (this.workflowMeta == null) {
            Workflow.setInternalHopVariables(this, null, null);
        } else {
            Workflow.setInternalHopVariables(this, this.workflowMeta.getFilename(), this.workflowMeta.getName());
        }
    }

    @Override
    public String getWorkflowName() {
        return this.workflowMeta == null ? null : this.workflowMeta.getName();
    }

    @Override
    public Result startExecution() {
        try {
            this.executionStartDate = new Date();
            this.logChannel = new LogChannel((Object)this.workflowMeta, this.parentLoggingObject, this.gatheringMetrics);
            this.loggingObject = new LoggingObject((Object)this);
            this.logLevel = this.logChannel.getLogLevel();
            this.workflowTracker = new WorkflowTracker<WorkflowMeta>(this.workflowMeta);
            this.result = this.previousResult == null ? new Result() : this.previousResult;
            IWorkflowEngineRunConfiguration engineRunConfiguration = this.workflowRunConfiguration.getEngineRunConfiguration();
            if (!(engineRunConfiguration instanceof RemoteWorkflowRunConfiguration)) {
                throw new HopException("The remote workflow engine expects a remote workflow configuration");
            }
            this.remoteWorkflowRunConfiguration = (RemoteWorkflowRunConfiguration)this.workflowRunConfiguration.getEngineRunConfiguration();
            String hopServerName = this.remoteWorkflowRunConfiguration.getHopServerName();
            if (StringUtils.isEmpty((String)hopServerName)) {
                throw new HopException("No remote Hop server was specified to run the workflow on");
            }
            String remoteRunConfigurationName = this.remoteWorkflowRunConfiguration.getRunConfigurationName();
            if (StringUtils.isEmpty((String)remoteRunConfigurationName)) {
                throw new HopException("No run configuration was specified to the remote workflow with");
            }
            if (this.metadataProvider == null) {
                throw new HopException("The remote workflow engine didn't receive a metadata to load hop server '" + hopServerName + "'");
            }
            this.logChannel.logBasic("Executing this workflow using the Remote Workflow Engine with run configuration '" + this.workflowRunConfiguration.getName() + "'");
            this.serverPollDelay = Const.toLong((String)this.resolve(this.remoteWorkflowRunConfiguration.getServerPollDelay()), (long)1000L);
            this.serverPollInterval = Const.toLong((String)this.resolve(this.remoteWorkflowRunConfiguration.getServerPollInterval()), (long)2000L);
            this.hopServer = (HopServer)this.metadataProvider.getSerializer(HopServer.class).load(hopServerName);
            if (this.hopServer == null) {
                throw new HopException("Hop server '" + hopServerName + "' could not be found");
            }
            WorkflowExecutionConfiguration workflowExecutionConfiguration = new WorkflowExecutionConfiguration();
            workflowExecutionConfiguration.setRunConfiguration(remoteRunConfigurationName);
            if (this.logLevel != null) {
                workflowExecutionConfiguration.setLogLevel(this.logLevel);
            }
            if (this.previousResult != null) {
                workflowExecutionConfiguration.setPreviousResult(this.previousResult);
            }
            workflowExecutionConfiguration.setGatheringMetrics(this.gatheringMetrics);
            Map<String, String> parametersMap = workflowExecutionConfiguration.getParametersMap();
            for (String variableName : this.getVariableNames()) {
                String variableValue = this.getVariable(variableName);
                if (variableName == null || variableValue == null) continue;
                parametersMap.put(variableName, variableValue);
            }
            this.sendToHopServer(this, this.workflowMeta, workflowExecutionConfiguration, this.metadataProvider);
            this.fireWorkflowStartedListeners();
            this.initialized = true;
            this.monitorRemoteWorkflowUntilFinished();
            this.fireWorkflowFinishListeners();
            this.executionEndDate = new Date();
        }
        catch (Exception e) {
            this.logChannel.logError("Error starting workflow", (Throwable)e);
            this.result.setNrErrors(this.result.getNrErrors() + 1L);
            try {
                this.fireWorkflowFinishListeners();
            }
            catch (Exception ex) {
                this.logChannel.logError("Error executing workflow finished listeners", (Throwable)ex);
                this.result.setNrErrors(this.result.getNrErrors() + 1L);
            }
        }
        return this.result;
    }

    public void monitorRemoteWorkflowUntilFinished() {
        try {
            Thread.sleep(this.serverPollDelay);
            while (!this.stopped && !this.finished) {
                this.getWorkflowStatus();
                Thread.sleep(this.serverPollInterval);
            }
        }
        catch (Exception e) {
            this.logChannel.logError("Error monitoring remote workflow", (Throwable)e);
            this.result.setNrErrors(1L);
        }
    }

    public synchronized void getWorkflowStatus() throws HopException {
        if (this.containerId == null) {
            return;
        }
        try {
            this.workflowStatus = this.hopServer.getWorkflowStatus(this, this.workflowMeta.getName(), this.containerId, this.lastLogLineNr);
            this.lastLogLineNr = this.workflowStatus.getLastLoggingLineNr();
            if (StringUtils.isNotEmpty((String)this.workflowStatus.getLoggingString())) {
                this.logChannel.logBasic(this.workflowStatus.getLoggingString());
            }
            this.finished = this.workflowStatus.isFinished();
            this.stopped = this.workflowStatus.isStopped();
            this.active = this.running = this.workflowStatus.isRunning();
            this.statusDescription = this.workflowStatus.getStatusDescription();
            this.result = this.workflowStatus.getResult();
        }
        catch (Exception e) {
            throw new HopException("Error getting workflow status", (Throwable)e);
        }
    }

    @Override
    public void stopExecution() {
        try {
            this.hopServer.stopWorkflow(this, this.workflowMeta.getName(), this.containerId);
            this.getWorkflowStatus();
        }
        catch (Exception e) {
            throw new RuntimeException("Stopping of pipeline '" + this.workflowMeta.getName() + "' with ID " + this.containerId + " failed", e);
        }
    }

    public void sendToHopServer(IVariables variables, WorkflowMeta workflowMeta, WorkflowExecutionConfiguration executionConfiguration, IHopMetadataProvider metadataProvider) throws HopException {
        if (this.hopServer == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Workflow.Log.NoHopServerSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)workflowMeta.getName())) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Workflow.Log.UniqueWorkflowName", (String[])new String[0]));
        }
        this.hopServer.getLogChannel().setLogLevel(executionConfiguration.getLogLevel());
        try {
            for (String var : this.getVariableNames()) {
                if (!RemotePipelineEngine.isVariablePassedToRemoteServer(var)) continue;
                executionConfiguration.getVariablesMap().put(var, this.getVariable(var));
            }
            if (this.remoteWorkflowRunConfiguration.isExportingResources()) {
                FileObject tempFile = HopVfs.createTempFile((String)"workflowExport", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
                TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(tempFile.getName().toString(), workflowMeta, this, metadataProvider, executionConfiguration, CONFIGURATION_IN_EXPORT_FILENAME, this.remoteWorkflowRunConfiguration.getNamedResourcesSourceFolder(), this.remoteWorkflowRunConfiguration.getNamedResourcesTargetFolder(), executionConfiguration.getVariablesMap());
                String result = this.hopServer.sendExport(this, topLevelResource.getArchiveName(), "workflow", topLevelResource.getBaseResourceName());
                WebResult webResult = WebResult.fromXmlString(result);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new HopException("There was an error passing the exported workflow to the remote server: " + Const.CR + webResult.getMessage());
                }
                this.containerId = webResult.getId();
            } else {
                String xml = new WorkflowConfiguration(workflowMeta, executionConfiguration, metadataProvider).getXml(variables);
                String reply = this.hopServer.sendXml(this, xml, "/hop/registerWorkflow/?xml=Y");
                WebResult webResult = WebResult.fromXmlString(reply);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    throw new HopException("There was an error posting the workflow on the remote server: " + Const.CR + webResult.getMessage());
                }
                this.containerId = webResult.getId();
            }
            WebResult webResult = this.hopServer.startWorkflow(this, workflowMeta.getName(), this.containerId);
            if (!webResult.getResult().equalsIgnoreCase("OK")) {
                throw new HopException("There was an error starting the workflow on the remote server: " + Const.CR + webResult.getMessage().replace('\t', '\n'));
            }
        }
        catch (HopException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkflowFinishedListener(IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>> finishedListener) {
        List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> list = this.workflowFinishedListeners;
        synchronized (list) {
            this.workflowFinishedListeners.add(finishedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireWorkflowFinishListeners() throws HopException {
        List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> list = this.workflowFinishedListeners;
        synchronized (list) {
            for (IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>> listener : this.workflowFinishedListeners) {
                listener.finished(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkflowStartedListener(IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>> finishedListener) {
        List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> list = this.workflowStartedListeners;
        synchronized (list) {
            this.workflowStartedListeners.add(finishedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireWorkflowStartedListeners() throws HopException {
        List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> list = this.workflowStartedListeners;
        synchronized (list) {
            for (IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>> listener : this.workflowStartedListeners) {
                listener.started(this);
            }
        }
    }

    @Override
    public void addActionListener(IActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(IActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public Date getRegistrationDate() {
        return null;
    }

    public String getLogChannelId() {
        return this.logChannel.getLogChannelId();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.WORKFLOW;
    }

    public ILoggingObject getParent() {
        return this.parentLoggingObject;
    }

    public String getObjectName() {
        return this.getWorkflowName();
    }

    public String getObjectCopy() {
        return null;
    }

    public String getFilename() {
        if (this.workflowMeta == null) {
            return null;
        }
        return this.workflowMeta.getFilename();
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void removeAllParameters() {
        this.namedParams.removeAllParameters();
    }

    public void clearParameterValues() {
        this.namedParams.clearParameterValues();
    }

    public void activateParameters(IVariables variables) {
        this.namedParams.activateParameters(variables);
    }

    public void copyParametersFromDefinitions(INamedParameterDefinitions definitions) {
        this.namedParams.copyParametersFromDefinitions(definitions);
    }

    @Override
    public WorkflowMeta getWorkflowMeta() {
        return this.workflowMeta;
    }

    @Override
    public void setWorkflowMeta(WorkflowMeta workflowMeta) {
        this.workflowMeta = workflowMeta;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public WorkflowRunConfiguration getWorkflowRunConfiguration() {
        return this.workflowRunConfiguration;
    }

    @Override
    public void setWorkflowRunConfiguration(WorkflowRunConfiguration workflowRunConfiguration) {
        this.workflowRunConfiguration = workflowRunConfiguration;
    }

    public Result getPreviousResult() {
        return this.previousResult;
    }

    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public void setResult(Result result) {
        this.result = result;
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public ILogChannel getLogChannel() {
        return this.logChannel;
    }

    public void setLogChannel(ILogChannel logChannel) {
        this.logChannel = logChannel;
    }

    public LoggingObject getLoggingObject() {
        return this.loggingObject;
    }

    public void setLoggingObject(LoggingObject loggingObject) {
        this.loggingObject = loggingObject;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public long getServerPollDelay() {
        return this.serverPollDelay;
    }

    public void setServerPollDelay(long serverPollDelay) {
        this.serverPollDelay = serverPollDelay;
    }

    public long getServerPollInterval() {
        return this.serverPollInterval;
    }

    public void setServerPollInterval(long serverPollInterval) {
        this.serverPollInterval = serverPollInterval;
    }

    public HopServer getHopServer() {
        return this.hopServer;
    }

    public void setHopServer(HopServer hopServer) {
        this.hopServer = hopServer;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public int getLastLogLineNr() {
        return this.lastLogLineNr;
    }

    public void setLastLogLineNr(int lastLogLineNr) {
        this.lastLogLineNr = lastLogLineNr;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public void setWorkflowStatus(HopServerWorkflowStatus workflowStatus) {
        this.workflowStatus = workflowStatus;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    @Override
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }

    @Override
    public List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> getWorkflowFinishedListeners() {
        return this.workflowFinishedListeners;
    }

    public void setWorkflowFinishedListeners(List<IExecutionFinishedListener<IWorkflowEngine<WorkflowMeta>>> workflowFinishedListeners) {
        this.workflowFinishedListeners = workflowFinishedListeners;
    }

    @Override
    public List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> getWorkflowStartedListeners() {
        return this.workflowStartedListeners;
    }

    public void setWorkflowStartedListeners(List<IExecutionStartedListener<IWorkflowEngine<WorkflowMeta>>> workflowStartedListeners) {
        this.workflowStartedListeners = workflowStartedListeners;
    }

    @Override
    public List<IActionListener> getActionListeners() {
        return this.actionListeners;
    }

    public void setActionListeners(List<IActionListener> actionListeners) {
        this.actionListeners = actionListeners;
    }

    public List<IDelegationListener> getDelegationListeners() {
        return this.delegationListeners;
    }

    public void setDelegationListeners(List<IDelegationListener> delegationListeners) {
        this.delegationListeners = delegationListeners;
    }

    @Override
    public Set<ActionMeta> getActiveActions() {
        return this.activeActions;
    }

    public void setActiveActions(Set<ActionMeta> activeActions) {
        this.activeActions = activeActions;
    }

    public INamedParameters getNamedParams() {
        return this.namedParams;
    }

    public void setNamedParams(INamedParameters namedParams) {
        this.namedParams = namedParams;
    }

    @Override
    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    public void setExtensionDataMap(Map<String, Object> extensionDataMap) {
        this.extensionDataMap = extensionDataMap;
    }

    public List<RowMetaAndData> getSourceRows() {
        return this.sourceRows;
    }

    @Override
    public void setSourceRows(List<RowMetaAndData> sourceRows) {
        this.sourceRows = sourceRows;
    }

    public ActionMeta getStartActionMeta() {
        return this.startActionMeta;
    }

    @Override
    public void setStartActionMeta(ActionMeta actionMeta) {
        this.startActionMeta = actionMeta;
    }

    @Override
    public WorkflowTracker getWorkflowTracker() {
        return this.workflowTracker;
    }

    public void setWorkflowTracker(WorkflowTracker workflowTracker) {
        this.workflowTracker = workflowTracker;
    }

    @Override
    public IWorkflowEngine<WorkflowMeta> getParentWorkflow() {
        return this.parentWorkflow;
    }

    @Override
    public void setParentWorkflow(IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        this.parentWorkflow = parentWorkflow;
    }

    @Override
    public IPipelineEngine getParentPipeline() {
        return this.parentPipeline;
    }

    @Override
    public void setParentPipeline(IPipelineEngine parentPipeline) {
        this.parentPipeline = parentPipeline;
    }

    public ILoggingObject getParentLoggingObject() {
        return this.parentLoggingObject;
    }

    public void setParentLoggingObject(ILoggingObject parentLoggingObject) {
        this.parentLoggingObject = parentLoggingObject;
    }

    public LinkedList<ActionResult> getActionResults() {
        return this.actionResults;
    }

    public boolean isForcingSeparateLogging() {
        return this.forcingSeparateLogging;
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        this.forcingSeparateLogging = forcingSeparateLogging;
    }

    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }
}

