/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.engines.local;

import java.util.List;
import java.util.UUID;
import org.apache.hop.core.Result;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.map.DatabaseConnectionMap;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.workflow.IActionListener;
import org.apache.hop.workflow.Workflow;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEnginePlugin;
import org.apache.hop.workflow.engines.local.LocalWorkflowRunConfiguration;

@WorkflowEnginePlugin(id="Local", name="Hop local workflow engine", description="Executes your workflow locally")
public class LocalWorkflowEngine
extends Workflow
implements IWorkflowEngine<WorkflowMeta> {
    public LocalWorkflowEngine() {
        this.setDefaultRunConfiguration();
    }

    public LocalWorkflowEngine(WorkflowMeta workflowMeta) {
        super(workflowMeta);
        this.setDefaultRunConfiguration();
    }

    public LocalWorkflowEngine(WorkflowMeta workflowMeta, ILoggingObject parent) {
        super(workflowMeta, parent);
        this.setDefaultRunConfiguration();
    }

    @Override
    public IWorkflowEngineRunConfiguration createDefaultWorkflowEngineRunConfiguration() {
        return new LocalWorkflowRunConfiguration();
    }

    private void setDefaultRunConfiguration() {
        this.setWorkflowRunConfiguration(new WorkflowRunConfiguration("local", "", this.createDefaultWorkflowEngineRunConfiguration()));
    }

    @Override
    public Result startExecution() {
        if (!(this.workflowRunConfiguration.getEngineRunConfiguration() instanceof LocalWorkflowRunConfiguration)) {
            this.log.logError("Error starting workflow", (Throwable)new HopException("A local workflow execution expects a local workflow configuration, not an instance of class " + this.workflowRunConfiguration.getEngineRunConfiguration().getClass().getName()));
            this.result = new Result();
            this.result.setNrErrors(1L);
            return this.result;
        }
        LocalWorkflowRunConfiguration config = (LocalWorkflowRunConfiguration)this.workflowRunConfiguration.getEngineRunConfiguration();
        Object parentExtensionData = this.getParentPipeline();
        if (parentExtensionData == null) {
            parentExtensionData = this.getParentWorkflow();
        }
        String connectionGroup = null;
        if (parentExtensionData != null && parentExtensionData.getExtensionDataMap() != null) {
            connectionGroup = (String)parentExtensionData.getExtensionDataMap().get("CONNECTION_GROUP");
        }
        if (config.isTransactional() && connectionGroup == null) {
            connectionGroup = this.getWorkflowMeta().getName() + " - " + UUID.randomUUID();
            this.addWorkflowFinishedListener((IWorkflowEngine<WorkflowMeta> workflow) -> {
                String group = (String)workflow.getExtensionDataMap().get("CONNECTION_GROUP");
                List databases = DatabaseConnectionMap.getInstance().getDatabases(group);
                Result result = workflow.getResult();
                for (Database database : databases) {
                    if (result.getResult() && !result.isStopped() && result.getNrErrors() == 0L) {
                        try {
                            database.commit(true);
                        }
                        catch (HopDatabaseException e) {
                            workflow.getLogChannel().logError("Error committing database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                            result.setNrErrors(result.getNrErrors() + 1L);
                        }
                        continue;
                    }
                    try {
                        database.rollback(true);
                    }
                    catch (HopDatabaseException e) {
                        workflow.getLogChannel().logError("Error rolling back database connection " + database.getDatabaseMeta().getName(), (Throwable)e);
                        result.setNrErrors(result.getNrErrors() + 1L);
                    }
                }
            });
        }
        if (connectionGroup != null && this.getExtensionDataMap() != null) {
            this.getExtensionDataMap().put("CONNECTION_GROUP", connectionGroup);
        }
        this.addActionListener(new IActionListener(){

            public void beforeExecution(IWorkflowEngine workflow, ActionMeta actionMeta, IAction action) {
                String connectionGroup = (String)workflow.getExtensionDataMap().get("CONNECTION_GROUP");
                if (connectionGroup != null) {
                    action.getExtensionDataMap().put("CONNECTION_GROUP", connectionGroup);
                }
            }

            public void afterExecution(IWorkflowEngine workflow, ActionMeta actionMeta, IAction action, Result result) {
            }
        });
        return super.startExecution();
    }
}

