/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action.validator;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.EmailValidator;
import org.apache.hop.workflow.action.validator.FileDoesNotExistValidator;
import org.apache.hop.workflow.action.validator.FileExistsValidator;
import org.apache.hop.workflow.action.validator.IntegerValidator;
import org.apache.hop.workflow.action.validator.LongValidator;
import org.apache.hop.workflow.action.validator.NotBlankValidator;
import org.apache.hop.workflow.action.validator.NotNullValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.action.validator.ValidatorMessages;

public class ActionValidatorUtils {
    public static final int LEVEL_FAILURE_DEFAULT = 4;

    public static AndValidator andValidator() {
        return AndValidator.INSTANCE;
    }

    public static NotBlankValidator notBlankValidator() {
        return NotBlankValidator.INSTANCE;
    }

    public static NotNullValidator notNullValidator() {
        return NotNullValidator.INSTANCE;
    }

    public static FileExistsValidator fileExistsValidator() {
        return FileExistsValidator.INSTANCE;
    }

    public static IntegerValidator integerValidator() {
        return IntegerValidator.INSTANCE;
    }

    public static LongValidator longValidator() {
        return LongValidator.INSTANCE;
    }

    public static FileDoesNotExistValidator fileDoesNotExistValidator() {
        return FileDoesNotExistValidator.INSTANCE;
    }

    public static EmailValidator emailValidator() {
        return EmailValidator.INSTANCE;
    }

    public static int getLevelOnFail(ValidatorContext context, String validatorName) {
        String key = ActionValidatorUtils.getKeyLevelOnFail(validatorName);
        if (context.containsKey(key)) {
            return (Integer)context.get(key);
        }
        if (context.containsKey("levelOnFail")) {
            return (Integer)context.get("levelOnFail");
        }
        return 4;
    }

    public static void putLevelOnFail(Map<String, Object> map, String validatorName, int levelOnFail) {
        String key = ActionValidatorUtils.getKeyLevelOnFail(validatorName);
        map.put(key, levelOnFail);
    }

    public static void putLevelOnFail(Map<String, Object> map, int levelOnFail) {
        map.put("levelOnFail", levelOnFail);
    }

    public static String getKeyLevelOnFail(String validatorName) {
        return validatorName + "-" + "levelOnFail";
    }

    public static boolean validateMask(ICheckResultSource source, String propertyName, List<ICheckResult> remarks, String mask, int levelOnFail) {
        throw new UnsupportedOperationException();
    }

    public static boolean validateMask(ICheckResultSource source, String propertyName, int levelOnFail, List<ICheckResult> remarks, String mask) {
        String VALIDATOR_NAME = "matches";
        String value = null;
        value = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        try {
            if (null == mask) {
                ActionValidatorUtils.addGeneralRemark(source, propertyName, "matches", remarks, "errors.missingVar", 4);
                return false;
            }
            if (StringUtils.isNotBlank((String)value) && !GenericValidator.matchRegexp((String)value, (String)mask)) {
                ActionValidatorUtils.addFailureRemark(source, propertyName, "matches", remarks, levelOnFail);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ActionValidatorUtils.addExceptionRemark(source, propertyName, "matches", remarks, e);
            return false;
        }
    }

    public static void addFailureRemark(ICheckResultSource source, String propertyName, String validatorName, List<ICheckResult> remarks, int level) {
        String key = "messages.failed." + validatorName;
        remarks.add((ICheckResult)new CheckResult(level, ValidatorMessages.getString(key, propertyName), source));
    }

    public static void addExceptionRemark(ICheckResultSource source, String propertyName, String validatorName, List<ICheckResult> remarks, Exception e) {
        String key = "messages.failed.unableToValidate";
        remarks.add((ICheckResult)new CheckResult(4, ValidatorMessages.getString(key, propertyName, e.getClass().getSimpleName() + ": " + e.getLocalizedMessage()), source));
    }

    public static void addGeneralRemark(ICheckResultSource source, String propertyName, String validatorName, List<ICheckResult> remarks, String key, int level) {
        remarks.add((ICheckResult)new CheckResult(4, ValidatorMessages.getString(key, new Object[0]), source));
    }

    public static void addOkRemark(ICheckResultSource source, String propertyName, List<ICheckResult> remarks) {
        int SUBSTRING_LENGTH = 20;
        String value = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        String substr = null;
        if (value != null) {
            substr = value.substring(0, Math.min(20, value.length()));
            if (value.length() > 20) {
                substr = substr + "...";
            }
        }
        remarks.add((ICheckResult)new CheckResult(1, ValidatorMessages.getString("messages.passed", propertyName, substr), source));
    }
}

