/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.Collections;
import java.util.List;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.BasePainter;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.IScrollBar;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.WorkflowPainterExtension;
import org.apache.hop.workflow.action.ActionMeta;

public class WorkflowPainter
extends BasePainter<WorkflowHopMeta, ActionMeta> {
    private WorkflowMeta workflowMeta;
    private ActionMeta startHopAction;
    private Point endHopLocation;
    private ActionMeta endHopAction;
    private ActionMeta noInputAction;
    private List<ActionMeta> activeActions;
    private List<ActionResult> actionResults;

    public WorkflowPainter(IGc gc, IVariables variables, WorkflowMeta workflowMeta, Point area, IScrollBar hori, IScrollBar vert, WorkflowHopMeta candidate, Rectangle selrect, List<AreaOwner> areaOwners, int iconSize, int lineWidth, int gridSize, String noteFontName, int noteFontHeight, double zoomFactor, boolean drawingEditIcons) {
        super(gc, variables, workflowMeta, area, hori, vert, selrect, areaOwners, iconSize, lineWidth, gridSize, noteFontName, noteFontHeight, zoomFactor, drawingEditIcons);
        this.workflowMeta = workflowMeta;
        this.candidate = candidate;
    }

    public void drawWorkflow() throws HopException {
        Point max = this.workflowMeta.getMaximum();
        Point thumb = this.getThumb(this.area, max);
        if (this.offset == null) {
            this.offset = this.getOffset(thumb, this.area);
        }
        this.gc.setTransform(0.0f, 0.0f, 1.0f);
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        this.gc.fillRectangle(0, 0, this.area.x, this.area.y);
        this.gc.setAlpha(255);
        this.gc.setTransform(this.translationX, this.translationY, this.magnification);
        this.drawActions();
        this.gc.dispose();
    }

    private void drawActions() throws HopException {
        Point end;
        Point start;
        Point to;
        Point fr;
        int i;
        if (this.gridSize > 1) {
            this.drawGrid();
        }
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowPainterStart.id, (Object)this);
        }
        catch (HopException e) {
            LogChannel.GENERAL.logError("Error in JobPainterStart extension point", (Throwable)e);
        }
        this.gc.setFont(IGc.EFont.NOTE);
        for (i = 0; i < this.workflowMeta.nrNotes(); ++i) {
            NotePadMeta ni = this.workflowMeta.getNote(i);
            this.drawNote(ni);
        }
        this.gc.setFont(IGc.EFont.GRAPH);
        for (i = 0; i < this.workflowMeta.nrWorkflowHops(); ++i) {
            WorkflowHopMeta hi = this.workflowMeta.getWorkflowHop(i);
            this.drawWorkflowHop(hi, false);
        }
        if (this.candidate != null) {
            this.drawWorkflowHop((WorkflowHopMeta)this.candidate, true);
        } else if (this.startHopAction != null && this.endHopLocation != null) {
            IGc.EImage arrow;
            fr = this.startHopAction.getLocation();
            to = this.endHopLocation;
            if (this.endHopAction == null) {
                this.gc.setForeground(IGc.EColor.GRAY);
                arrow = IGc.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(IGc.EColor.BLUE);
                arrow = IGc.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x + this.iconSize / 2, fr.y + this.iconSize / 2);
            end = this.real2screen(to.x, to.y);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y, this.theta, this.calcArrowLength(), 1.2, (WorkflowHopMeta)null, (Object)this.startHopAction, this.endHopAction == null ? this.endHopLocation : this.endHopAction);
        } else if (this.endHopAction != null && this.endHopLocation != null) {
            IGc.EImage arrow;
            fr = this.endHopLocation;
            to = this.endHopAction.getLocation();
            if (this.startHopAction == null) {
                this.gc.setForeground(IGc.EColor.GRAY);
                arrow = IGc.EImage.ARROW_DISABLED;
            } else {
                this.gc.setForeground(IGc.EColor.BLUE);
                arrow = IGc.EImage.ARROW_DEFAULT;
            }
            start = this.real2screen(fr.x, fr.y);
            end = this.real2screen(to.x + this.iconSize / 2, to.y + this.iconSize / 2);
            this.drawArrow(arrow, start.x, start.y, end.x, end.y + this.iconSize / 2, this.theta, this.calcArrowLength(), 1.2, (WorkflowHopMeta)null, this.startHopAction == null ? this.endHopLocation : this.startHopAction, (Object)this.endHopAction);
        }
        for (int j = 0; j < this.workflowMeta.nrActions(); ++j) {
            ActionMeta je = this.workflowMeta.getAction(j);
            this.drawAction(je);
        }
        if (this.noInputAction != null) {
            this.gc.setLineWidth(2);
            this.gc.setForeground(IGc.EColor.RED);
            Point n = this.noInputAction.getLocation();
            this.gc.drawLine(this.offset.x + n.x - 5, this.offset.y + n.y - 5, this.offset.x + n.x + this.iconSize + 5, this.offset.y + n.y + this.iconSize + 5);
            this.gc.drawLine(this.offset.x + n.x - 5, this.offset.y + n.y + this.iconSize + 5, this.offset.x + n.x + this.iconSize + 5, this.offset.y + n.y - 5);
        }
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowPainterEnd.id, (Object)this);
        }
        catch (HopException e) {
            LogChannel.GENERAL.logError("Error in JobPainterEnd extension point", (Throwable)e);
        }
        this.drawRect(this.selectionRectangle);
    }

    protected void drawAction(ActionMeta actionMeta) throws HopException {
        int alpha = this.gc.getAlpha();
        Point pt = actionMeta.getLocation();
        if (pt == null) {
            pt = new Point(50, 50);
        }
        Point screen = this.real2screen(pt.x, pt.y);
        int x = screen.x;
        int y = screen.y;
        String name = actionMeta.getName();
        if (actionMeta.isSelected()) {
            this.gc.setLineWidth(3);
        } else {
            this.gc.setLineWidth(1);
        }
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        this.gc.fillRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 7, 7);
        this.gc.drawActionIcon(x, y, actionMeta, this.magnification);
        this.areaOwners.add(new AreaOwner<Object, ActionMeta>(AreaOwner.AreaType.ACTION_ICON, x, y, this.iconSize, this.iconSize, this.offset, this.subject, actionMeta));
        if (actionMeta.isMissing()) {
            this.gc.setForeground(IGc.EColor.RED);
        } else if (actionMeta.isDeprecated()) {
            this.gc.setForeground(IGc.EColor.DEPRECATED);
        } else {
            this.gc.setForeground(IGc.EColor.CRYSTAL);
        }
        this.gc.drawRoundRectangle(x - 1, y - 1, this.iconSize + 1, this.iconSize + 1, 7, 7);
        this.gc.setForeground(IGc.EColor.CRYSTAL);
        Point textsize = new Point(this.gc.textExtent((String)new StringBuilder().append((String)"").append((String)name).toString()).x, this.gc.textExtent((String)new StringBuilder().append((String)"").append((String)name).toString()).y);
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        this.gc.setLineWidth(1);
        int xPos = x + this.iconSize / 2 - textsize.x / 2;
        int yPos = y + this.iconSize + 5;
        this.gc.setForeground(IGc.EColor.BLACK);
        if (this.isDrawingEditIcons()) {
            Point nameExtent = this.gc.textExtent(name);
            int tmpAlpha = this.gc.getAlpha();
            this.gc.setAlpha(230);
            this.gc.drawImage(IGc.EImage.EDIT, xPos - 6, yPos - 2, this.magnification);
            this.gc.setBackground(IGc.EColor.LIGHTGRAY);
            this.gc.fillRoundRectangle(xPos - 8, yPos - 2, nameExtent.x + 15, nameExtent.y + 8, 25, 25);
            this.gc.setAlpha(tmpAlpha);
            this.areaOwners.add(new AreaOwner<ActionMeta, String>(AreaOwner.AreaType.ACTION_NAME, xPos - 8, yPos - 2, nameExtent.x + 15, nameExtent.y + 4, this.offset, actionMeta, name));
        }
        this.gc.drawText(name, xPos, yPos, true);
        if (this.activeActions != null && this.activeActions.contains(actionMeta)) {
            this.gc.setForeground(IGc.EColor.BLUE);
            int iconX = x + this.iconSize - this.miniIconSize / 2;
            int iconY = y - this.miniIconSize / 2;
            this.gc.drawImage(IGc.EImage.BUSY, iconX, iconY, this.magnification);
            this.areaOwners.add(new AreaOwner<Object, ActionMeta>(AreaOwner.AreaType.ACTION_BUSY, iconX, iconY, this.miniIconSize, this.miniIconSize, this.offset, this.subject, actionMeta));
        } else {
            this.gc.setForeground(IGc.EColor.BLACK);
        }
        ActionResult actionResult = this.findActionResult(actionMeta);
        if (actionResult != null) {
            Result result = actionResult.getResult();
            int iconX = x + this.iconSize - this.miniIconSize / 2;
            int iconY = y - this.miniIconSize / 2;
            if (actionResult.isCheckpoint()) {
                this.gc.drawImage(IGc.EImage.CHECKPOINT, iconX, iconY, this.magnification);
                this.areaOwners.add(new AreaOwner<ActionMeta, ActionResult>(AreaOwner.AreaType.ACTION_RESULT_CHECKPOINT, iconX, iconY, this.miniIconSize, this.miniIconSize, this.offset, actionMeta, actionResult));
            } else if (result.getResult()) {
                this.gc.drawImage(IGc.EImage.SUCCESS, iconX, iconY, this.magnification);
                this.areaOwners.add(new AreaOwner<ActionMeta, ActionResult>(AreaOwner.AreaType.ACTION_RESULT_SUCCESS, iconX, iconY, this.miniIconSize, this.miniIconSize, this.offset, actionMeta, actionResult));
            } else {
                this.gc.drawImage(IGc.EImage.FAILURE, iconX, iconY, this.magnification);
                this.areaOwners.add(new AreaOwner<ActionMeta, ActionResult>(AreaOwner.AreaType.ACTION_RESULT_FAILURE, iconX, iconY, this.miniIconSize, this.miniIconSize, this.offset, actionMeta, actionResult));
            }
        }
        WorkflowPainterExtension extension = new WorkflowPainterExtension(this.gc, this.areaOwners, this.workflowMeta, null, actionMeta, x, y, 0, 0, 0, 0, this.offset, this.iconSize);
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowPainterAction.id, (Object)extension);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error calling extension point(s) for the workflow painter action", (Throwable)e);
        }
        this.gc.setAlpha(alpha);
    }

    private ActionResult findActionResult(ActionMeta actionMeta) {
        if (this.actionResults == null) {
            return null;
        }
        for (ActionResult actionResult : this.actionResults) {
            if (!actionResult.getActionName().equals(actionMeta.getName())) continue;
            return actionResult;
        }
        return null;
    }

    protected void drawWorkflowHop(WorkflowHopMeta hop, boolean candidate) throws HopException {
        if (hop == null || hop.getFromAction() == null || hop.getToAction() == null) {
            return;
        }
        this.drawLine(hop, candidate);
    }

    protected void drawLine(WorkflowHopMeta workflowHop, boolean is_candidate) throws HopException {
        IGc.EImage arrow;
        IGc.EColor color;
        int[] line = this.getLine(workflowHop.getFromAction(), workflowHop.getToAction());
        this.gc.setLineWidth(this.lineWidth);
        if (workflowHop.getFromAction().isLaunchingInParallel()) {
            this.gc.setLineStyle(IGc.ELineStyle.PARALLEL);
        } else {
            this.gc.setLineStyle(IGc.ELineStyle.SOLID);
        }
        if (is_candidate) {
            color = IGc.EColor.BLUE;
            arrow = IGc.EImage.ARROW_CANDIDATE;
        } else if (workflowHop.isEnabled()) {
            if (workflowHop.isUnconditional()) {
                color = IGc.EColor.HOP_DEFAULT;
                arrow = IGc.EImage.ARROW_DEFAULT;
            } else if (workflowHop.getEvaluation()) {
                color = IGc.EColor.HOP_TRUE;
                arrow = IGc.EImage.ARROW_TRUE;
            } else {
                color = IGc.EColor.HOP_FALSE;
                arrow = IGc.EImage.ARROW_FALSE;
            }
        } else {
            color = IGc.EColor.GRAY;
            arrow = IGc.EImage.ARROW_DISABLED;
        }
        this.gc.setForeground(color);
        if (workflowHop.isSplit()) {
            this.gc.setLineWidth(this.lineWidth + 2);
        }
        this.drawArrow(arrow, line, workflowHop);
        if (workflowHop.isSplit()) {
            this.gc.setLineWidth(this.lineWidth);
        }
        this.gc.setForeground(IGc.EColor.BLACK);
        this.gc.setBackground(IGc.EColor.BACKGROUND);
        this.gc.setLineStyle(IGc.ELineStyle.SOLID);
    }

    private void drawArrow(IGc.EImage arrow, int[] line, WorkflowHopMeta workflowHop) throws HopException {
        this.drawArrow(arrow, line, workflowHop, workflowHop.getFromAction(), workflowHop.getToAction());
    }

    @Override
    protected void drawArrow(IGc.EImage arrow, int x1, int y1, int x2, int y2, double theta, int size, double factor, WorkflowHopMeta workflowHop, Object startObject, Object endObject) throws HopException {
        boolean q4;
        this.gc.drawLine(x1, y1, x2, y2);
        int a = Math.abs(x2 - x1);
        int b = Math.abs(y2 - y1);
        int dist = (int)Math.sqrt(a * a + b * b);
        if (factor < 0.0) {
            factor = dist >= 2 * this.iconSize ? 1.3 : 1.2;
        }
        int mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
        int my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
        double angle = Math.atan2(y2 - y1, x2 - x1) + 1.5707963267948966;
        boolean q1 = Math.toDegrees(angle) >= 0.0 && Math.toDegrees(angle) < 90.0;
        boolean q2 = Math.toDegrees(angle) >= 90.0 && Math.toDegrees(angle) < 180.0;
        boolean q3 = Math.toDegrees(angle) >= 180.0 && Math.toDegrees(angle) < 270.0;
        boolean bl = q4 = Math.toDegrees(angle) >= 270.0 || Math.toDegrees(angle) < 0.0;
        if (q1 || q3) {
            this.gc.drawImage(arrow, mx, my + 1, this.magnification, angle);
        } else if (q2 || q4) {
            this.gc.drawImage(arrow, mx, my, this.magnification, angle);
        }
        factor = 0.8;
        mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0) - this.miniIconSize / 2;
        my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0) - this.miniIconSize / 2;
        if (workflowHop != null) {
            if (workflowHop.getFromAction().isLaunchingInParallel()) {
                mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
                my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
                this.gc.drawImage(IGc.EImage.PARALLEL, mx, my, this.magnification, angle);
                this.areaOwners.add(new AreaOwner<Object, WorkflowHopMeta>(AreaOwner.AreaType.WORKFLOW_HOP_PARALLEL_ICON, mx, my, this.miniIconSize, this.miniIconSize, this.offset, this.subject, workflowHop));
            } else {
                IGc.EImage hopsIcon = workflowHop.isUnconditional() ? IGc.EImage.UNCONDITIONAL : (workflowHop.getEvaluation() ? IGc.EImage.TRUE : IGc.EImage.FALSE);
                this.gc.drawImage(hopsIcon, mx, my, this.magnification);
                this.areaOwners.add(new AreaOwner<Object, WorkflowHopMeta>(AreaOwner.AreaType.WORKFLOW_HOP_ICON, mx, my, this.miniIconSize, this.miniIconSize, this.offset, this.subject, workflowHop));
            }
            WorkflowPainterExtension extension = new WorkflowPainterExtension(this.gc, this.areaOwners, this.workflowMeta, workflowHop, null, x1, y1, x2, y2, mx, my, this.offset, this.iconSize);
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.GENERAL, (IVariables)this.variables, (String)HopExtensionPoint.WorkflowPainterArrow.id, (Object)extension);
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error calling extension point(s) for the workflow painter arrow", (Throwable)e);
            }
        }
    }

    public void setStartHopAction(ActionMeta action) {
        this.startHopAction = action;
    }

    public void setEndHopLocation(Point location) {
        this.endHopLocation = location;
    }

    public void setEndHopAction(ActionMeta action) {
        this.endHopAction = action;
    }

    public void setNoInputAction(ActionMeta action) {
        this.noInputAction = action;
    }

    public void setActiveActions(List<ActionMeta> activeActions) {
        this.activeActions = activeActions;
    }

    public List<ActionResult> getActionResults() {
        return this.actionResults;
    }

    public void setActionResults(List<ActionResult> actionResults) {
        this.actionResults = actionResults;
        Collections.sort(this.actionResults);
    }

    public WorkflowMeta getWorkflowMeta() {
        return this.workflowMeta;
    }

    public void setWorkflowMeta(WorkflowMeta workflowMeta) {
        this.workflowMeta = workflowMeta;
    }

    public ActionMeta getStartHopAction() {
        return this.startHopAction;
    }

    public Point getEndHopLocation() {
        return this.endHopLocation;
    }

    public ActionMeta getEndHopAction() {
        return this.endHopAction;
    }

    public ActionMeta getNoInputAction() {
        return this.noInputAction;
    }

    public List<ActionMeta> getActiveActions() {
        return this.activeActions;
    }
}

