/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.injector;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.injector.Injector;
import org.apache.hop.pipeline.transforms.injector.InjectorData;
import org.apache.hop.pipeline.transforms.injector.InjectorField;

@Transform(id="Injector", image="ui/images/injector.svg", name="i18n:org.apache.hop.pipeline.transform:BaseTransform.TypeLongDesc.Injector", description="i18n:org.apache.hop.pipeline.transform:BaseTransform.TypeTooltipDesc.Injector", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Inline", keywords={""}, documentationUrl="/pipeline/transforms/injector.html")
public class InjectorMeta
extends BaseTransformMeta
implements ITransformMeta<Injector, InjectorData> {
    private static final Class<?> PKG = InjectorMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<InjectorField> injectorFields = new ArrayList<InjectorField>();

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (InjectorField field : this.injectorFields) {
            try {
                inputRowMeta.addValueMeta(field.createValueMeta(variables));
            }
            catch (HopException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    @Override
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"InjectorMeta.CheckResult.TransformExpectingNoReadingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"InjectorMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public Injector createTransform(TransformMeta transformMeta, InjectorData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new Injector(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    @Override
    public InjectorData getTransformData() {
        return new InjectorData();
    }

    public List<InjectorField> getInjectorFields() {
        return this.injectorFields;
    }

    public void setInjectorFields(List<InjectorField> injectorFields) {
        this.injectorFields = injectorFields;
    }
}

