/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.file;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.ITextFileInputField;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;

public class BaseFileField
implements Cloneable,
ITextFileInputField {
    @Injection(name="FIELD_NAME", group="FIELDS")
    private String name;
    @Injection(name="FIELD_POSITION", group="FIELDS")
    private int position = -1;
    @Injection(name="FIELD_LENGTH", group="FIELDS")
    private int length = -1;
    private int type;
    @Injection(name="FIELD_IGNORE", group="FIELDS")
    private boolean ignore;
    @Injection(name="FIELD_FORMAT", group="FIELDS")
    private String format;
    private int trimtype;
    @Injection(name="FIELD_PRECISION", group="FIELDS")
    private int precision = -1;
    @Injection(name="FIELD_CURRENCY", group="FIELDS")
    private String currencySymbol;
    @Injection(name="FIELD_DECIMAL", group="FIELDS")
    private String decimalSymbol;
    @Injection(name="FIELD_GROUP", group="FIELDS")
    private String groupSymbol;
    @Injection(name="FIELD_REPEAT", group="FIELDS")
    private boolean repeat;
    @Injection(name="FIELD_NULL_STRING", group="FIELDS")
    private String nullString;
    @Injection(name="FIELD_IF_NULL", group="FIELDS")
    private String ifNullValue;
    private String[] samples;
    private NumberFormat nf;
    private DecimalFormat df;
    private DecimalFormatSymbols dfs;
    private SimpleDateFormat daf;
    private static final String[] dateFormats = new String[]{"yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss", "dd/MM/yyyy", "dd-MM-yyyy", "yyyy/MM/dd", "yyyy-MM-dd", "yyyyMMdd", "ddMMyyyy", "d-M-yyyy", "d/M/yyyy", "d-M-yy", "d/M/yy"};
    private static final String[] numberFormats = new String[]{"", "#", Const.DEFAULT_NUMBER_FORMAT, "0.00", "0000000000000", "###,###,###.#######", "###############.###############", "#####.###############%"};

    public BaseFileField(String fieldname, int position, int length) {
        this.name = fieldname;
        this.position = position;
        this.length = length;
        this.type = 2;
        this.ignore = false;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
        this.nullString = "";
        this.ifNullValue = "";
    }

    public BaseFileField() {
        this(null, -1, -1);
    }

    public int compare(Object obj) {
        BaseFileField field = (BaseFileField)obj;
        return this.position - field.getPosition();
    }

    public int compareTo(ITextFileInputField field) {
        return this.position - field.getPosition();
    }

    public boolean equal(Object obj) {
        BaseFileField field = (BaseFileField)obj;
        return this.position == field.getPosition();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalArgumentException("Clone not supported for " + this.getClass().getName());
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMetaFactory.getValueMetaName((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    @Injection(name="FIELD_TYPE", group="FIELDS")
    public void setType(String value) {
        this.type = ValueMetaFactory.getIdForValueMeta((String)value);
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    public void setIgnored(boolean ignore) {
        this.ignore = ignore;
    }

    public void flipIgnored() {
        this.ignore = !this.ignore;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return ValueMetaString.getTrimTypeCode((int)this.trimtype);
    }

    public String getTrimTypeDesc() {
        return ValueMetaString.getTrimTypeDesc((int)this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    @Injection(name="FIELD_TRIM_TYPE", group="FIELDS")
    public void setTrimType(String value) {
        this.trimtype = ValueMetaString.getTrimTypeByCode((String)value);
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getIfNullValue() {
        return this.ifNullValue;
    }

    public void setIfNullValue(String ifNullValue) {
        this.ifNullValue = ifNullValue;
    }

    public String toString() {
        return this.name + "@" + this.position + ":" + this.length;
    }

    public void guess() {
        this.guessTrimType();
        this.guessType();
        this.guessIgnore();
    }

    public void guessTrimType() {
        boolean spaces_before = false;
        boolean spaces_after = false;
        for (int i = 0; i < this.samples.length; ++i) {
            spaces_before |= Const.nrSpacesBefore((String)this.samples[i]) > 0;
            spaces_after |= Const.nrSpacesAfter((String)this.samples[i]) > 0;
            this.samples[i] = Const.trim((String)this.samples[i]);
        }
        this.trimtype = 0;
        if (spaces_before) {
            this.trimtype |= 1;
        }
        if (spaces_after) {
            this.trimtype |= 2;
        }
    }

    public void guessType() {
        this.nf = NumberFormat.getInstance();
        this.df = (DecimalFormat)this.nf;
        this.dfs = new DecimalFormatSymbols();
        this.daf = new SimpleDateFormat();
        this.daf.setLenient(false);
        this.type = 2;
        if (this.samples == null) {
            return;
        }
        int datefmt_cnt = dateFormats.length;
        boolean[] datefmt = new boolean[dateFormats.length];
        for (int i = 0; i < dateFormats.length; ++i) {
            datefmt[i] = true;
        }
        int datenul = 0;
        for (int i = 0; i < this.samples.length; ++i) {
            if (this.samples[i].length() > 0 && this.samples[i].equalsIgnoreCase(this.nullString)) {
                ++datenul;
                continue;
            }
            for (int x = 0; x < dateFormats.length; ++x) {
                if (this.samples[i] == null || Const.onlySpaces((String)this.samples[i]) || this.samples[i].length() == 0) {
                    datefmt[x] = false;
                    --datefmt_cnt;
                }
                if (!datefmt[x]) continue;
                try {
                    this.daf.applyPattern(dateFormats[x]);
                    Date date = this.daf.parse(this.samples[i]);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    int year = cal.get(1);
                    if (year >= 1800 && year <= 2200) continue;
                    datefmt[x] = false;
                    --datefmt_cnt;
                    continue;
                }
                catch (Exception e) {
                    datefmt[x] = false;
                    --datefmt_cnt;
                }
            }
        }
        if (datefmt_cnt > 0 && datenul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < dateFormats.length && first < 0; ++i) {
                if (!datefmt[i]) continue;
                first = i;
            }
            this.type = 3;
            this.format = dateFormats[first];
            return;
        }
        boolean isnumber = true;
        this.decimalSymbol = "" + this.dfs.getDecimalSeparator();
        this.groupSymbol = "" + this.dfs.getGroupingSeparator();
        boolean[] numfmt = new boolean[numberFormats.length];
        int[] maxprecision = new int[numberFormats.length];
        for (int i = 0; i < numfmt.length; ++i) {
            numfmt[i] = true;
            maxprecision[i] = -1;
        }
        int numfmt_cnt = numberFormats.length;
        int numnul = 0;
        for (int i = 0; i < this.samples.length && isnumber; ++i) {
            int x;
            boolean contains_dot = false;
            boolean containsComma = false;
            String field = this.samples[i];
            if (field.length() > 0 && field.equalsIgnoreCase(this.nullString)) {
                ++numnul;
                continue;
            }
            for (x = 0; x < field.length() && isnumber; ++x) {
                char ch = field.charAt(x);
                if (!(Character.isDigit(ch) || ch == '.' || ch == ',' || ch == '-' && x <= 0 || ch == 'E' || ch == 'e')) {
                    isnumber = false;
                    numfmt_cnt = 0;
                    continue;
                }
                if (ch == '.') {
                    contains_dot = true;
                }
                if (ch != ',') continue;
                containsComma = true;
            }
            if (!isnumber) continue;
            if (contains_dot && !containsComma) {
                this.dfs.setDecimalSeparator('.');
                this.decimalSymbol = ".";
                this.dfs.setGroupingSeparator(',');
                this.groupSymbol = ",";
            } else if (!contains_dot && containsComma) {
                this.dfs.setDecimalSeparator(',');
                this.decimalSymbol = ",";
                this.dfs.setGroupingSeparator('.');
                this.groupSymbol = ".";
            } else if (contains_dot && containsComma) {
                int idxCom;
                int idx_dot = field.indexOf(46);
                if (idx_dot > (idxCom = field.indexOf(44))) {
                    this.dfs.setDecimalSeparator('.');
                    this.decimalSymbol = ".";
                    this.dfs.setGroupingSeparator(',');
                    this.groupSymbol = ",";
                } else {
                    this.dfs.setDecimalSeparator(',');
                    this.decimalSymbol = ",";
                    this.dfs.setGroupingSeparator('.');
                    this.groupSymbol = ".";
                }
            }
            for (x = 0; x < numberFormats.length; ++x) {
                if (!numfmt[x]) continue;
                boolean islong = true;
                try {
                    int prec = -1;
                    if (!contains_dot && !containsComma) {
                        try {
                            Long.parseLong(field);
                            prec = 0;
                        }
                        catch (Exception e) {
                            islong = false;
                        }
                    }
                    if (!islong) {
                        this.df.setDecimalFormatSymbols(this.dfs);
                        this.df.applyPattern(numberFormats[x]);
                        double d = this.df.parse(field).doubleValue();
                        prec = BaseFileField.guessPrecision(d);
                    }
                    if (prec <= maxprecision[x]) continue;
                    maxprecision[x] = prec;
                    continue;
                }
                catch (Exception e) {
                    numfmt[x] = false;
                    --numfmt_cnt;
                }
            }
        }
        if (numfmt_cnt > 0 && numnul != this.samples.length) {
            int first = -1;
            for (int i = 0; i < numberFormats.length && first < 0; ++i) {
                if (!numfmt[i]) continue;
                first = i;
            }
            this.type = 1;
            this.format = numberFormats[first];
            this.precision = maxprecision[first];
            return;
        }
        this.type = 2;
        this.format = "";
        this.precision = -1;
        this.decimalSymbol = "";
        this.groupSymbol = "";
        this.currencySymbol = "";
    }

    public static final int guessPrecision(double d) {
        int maxprec = 4;
        double maxdiff = 5.0E-5;
        double diff = Math.abs(Math.floor(d) - d);
        if (diff < maxdiff) {
            return 0;
        }
        for (int i = 1; i < maxprec; ++i) {
            double factor = Math.pow(10.0, i);
            diff = Math.abs(Math.floor(d * factor) - d * factor);
            if (diff < maxdiff) {
                return i;
            }
            factor *= 10.0;
        }
        return -1;
    }

    public void guessIgnore() {
        int i;
        boolean stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (Const.onlySpaces((String)this.samples[i])) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
        stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (this.samples[i].length() <= 0) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
        stop = false;
        for (i = 0; i < this.samples.length && !stop; ++i) {
            if (this.samples[i].equalsIgnoreCase(this.nullString)) continue;
            stop = true;
        }
        if (!stop) {
            this.ignore = true;
            return;
        }
    }

    public ITextFileInputField createNewInstance(String newFieldname, int x, int newlength) {
        return new BaseFileField(newFieldname, x, newlength);
    }
}

