/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform.errorhandling;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.errorhandling.IFileErrorHandler;

public abstract class AbstractFileErrorHandler
implements IFileErrorHandler {
    private static final Class<?> PKG = AbstractFileErrorHandler.class;
    private static final String DD_MMYYYY_HHMMSS = "ddMMyyyy-HHmmss";
    public static final String NO_PARTS = "NO_PARTS";
    private final String destinationDirectory;
    private final String fileExtension;
    private final String encoding;
    private String processingFilename;
    private Map<Object, Writer> writers;
    private String dateString;
    private BaseTransform baseTransform;

    public AbstractFileErrorHandler(Date date, String destinationDirectory, String fileExtension, String encoding, BaseTransform baseTransform) {
        this.destinationDirectory = destinationDirectory;
        this.fileExtension = fileExtension;
        this.encoding = encoding;
        this.baseTransform = baseTransform;
        this.writers = new HashMap<Object, Writer>();
        this.initDateFormatter(date);
    }

    private void initDateFormatter(Date date) {
        this.dateString = AbstractFileErrorHandler.createDateFormat().format(date);
    }

    public static DateFormat createDateFormat() {
        return new SimpleDateFormat(DD_MMYYYY_HHMMSS);
    }

    public static FileObject getReplayFilename(String destinationDirectory, String processingFilename, String dateString, String extension, Object source) throws HopFileException {
        String name = null;
        String sourceAdding = "";
        if (!NO_PARTS.equals(source)) {
            sourceAdding = "_" + source.toString();
        }
        name = extension == null || extension.length() == 0 ? processingFilename + sourceAdding + "." + dateString : processingFilename + sourceAdding + "." + dateString + "." + extension;
        return HopVfs.getFileObject((String)(destinationDirectory + "/" + name));
    }

    public static FileObject getReplayFilename(String destinationDirectory, String processingFilename, Date date, String extension, Object source) throws HopFileException {
        return AbstractFileErrorHandler.getReplayFilename(destinationDirectory, processingFilename, AbstractFileErrorHandler.createDateFormat().format(date), extension, source);
    }

    Writer getWriter(Object source) throws HopException {
        try {
            Writer outputStreamWriter = this.writers.get(source);
            if (outputStreamWriter != null) {
                return outputStreamWriter;
            }
            FileObject file = AbstractFileErrorHandler.getReplayFilename(this.destinationDirectory, this.processingFilename, this.dateString, this.fileExtension, source);
            ResultFile resultFile = new ResultFile(0, file, this.baseTransform.getPipelineMeta().getName(), this.baseTransform.getTransformName());
            this.baseTransform.addResultFile(resultFile);
            try {
                outputStreamWriter = this.encoding == null ? new OutputStreamWriter(HopVfs.getOutputStream((FileObject)file, (boolean)false)) : new OutputStreamWriter(HopVfs.getOutputStream((FileObject)file, (boolean)false), this.encoding);
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Exception.CouldNotCreateFileErrorHandlerForFile", (String[])new String[0]) + file.getName().getURI(), (Throwable)e);
            }
            this.writers.put(source, outputStreamWriter);
            return outputStreamWriter;
        }
        catch (HopFileException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Exception.CouldNotCreateFileErrorHandlerForFile", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void close() throws HopException {
        Iterator<Writer> iter = this.writers.values().iterator();
        while (iter.hasNext()) {
            this.close(iter.next());
        }
        this.writers = new HashMap<Object, Writer>();
    }

    private void close(Writer outputStreamWriter) throws HopException {
        if (outputStreamWriter != null) {
            try {
                outputStreamWriter.flush();
            }
            catch (IOException exception) {
                this.baseTransform.logError(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Log.CouldNotFlushContentToFile", (String[])new String[0]), exception.getLocalizedMessage());
            }
            try {
                outputStreamWriter.close();
            }
            catch (IOException exception) {
                throw new HopException(BaseMessages.getString(PKG, (String)"AbstractFileErrorHandler.Exception.CouldNotCloseFile", (String[])new String[0]), (Throwable)exception);
            }
            finally {
                outputStreamWriter = null;
            }
        }
    }

    @Override
    public void handleFile(FileObject file) throws HopException {
        this.close();
        this.processingFilename = file.getName().getBaseName();
    }
}

