/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;

public class TransformIOMeta
implements ITransformIOMeta,
Cloneable {
    private boolean inputAcceptor;
    private boolean outputProducer;
    private boolean inputOptional;
    private boolean outputDynamic;
    private boolean inputDynamic;
    private List<IStream> streams;
    private boolean sortedDataRequired;
    private String generalInfoDescription;
    private String generalTargetDescription;

    public TransformIOMeta(boolean inputAcceptor, boolean outputProducer, boolean inputOptional, boolean sortedDataRequired, boolean inputDynamic, boolean outputDynamic) {
        this.inputAcceptor = inputAcceptor;
        this.outputProducer = outputProducer;
        this.inputOptional = inputOptional;
        this.sortedDataRequired = sortedDataRequired;
        this.streams = Collections.synchronizedList(new ArrayList());
        this.inputDynamic = inputDynamic;
        this.outputDynamic = outputDynamic;
    }

    protected TransformIOMeta clone() throws CloneNotSupportedException {
        TransformIOMeta ioMeta = (TransformIOMeta)super.clone();
        ArrayList<IStream> cloneStreams = new ArrayList<IStream>(this.streams);
        ioMeta.streams = Collections.synchronizedList(cloneStreams);
        return ioMeta;
    }

    @Override
    public boolean isInputAcceptor() {
        return this.inputAcceptor;
    }

    public void setInputAcceptor(boolean inputAcceptor) {
        this.inputAcceptor = inputAcceptor;
    }

    @Override
    public boolean isOutputProducer() {
        return this.outputProducer;
    }

    public void setOutputProducer(boolean outputProducer) {
        this.outputProducer = outputProducer;
    }

    @Override
    public boolean isInputOptional() {
        return this.inputOptional;
    }

    public void setInputOptional(boolean inputOptional) {
        this.inputOptional = inputOptional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IStream> getInfoStreams() {
        ArrayList<IStream> list = new ArrayList<IStream>();
        List<IStream> list2 = this.streams;
        synchronized (list2) {
            for (IStream stream : this.streams) {
                if (!stream.getStreamType().equals((Object)IStream.StreamType.INFO)) continue;
                list.add(stream);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IStream> getTargetStreams() {
        ArrayList<IStream> list = new ArrayList<IStream>();
        List<IStream> list2 = this.streams;
        synchronized (list2) {
            for (IStream stream : this.streams) {
                if (!stream.getStreamType().equals((Object)IStream.StreamType.TARGET)) continue;
                list.add(stream);
            }
        }
        return list;
    }

    @Override
    public boolean isSortedDataRequired() {
        return this.sortedDataRequired;
    }

    public void setSortedDataRequired(boolean sortedDataRequired) {
        this.sortedDataRequired = sortedDataRequired;
    }

    @Override
    public void addStream(IStream stream) {
        this.streams.add(stream);
    }

    @Override
    public String[] getInfoTransformNames() {
        List<IStream> infoStreams = this.getInfoStreams();
        String[] names = new String[infoStreams.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = infoStreams.get(i).getTransformName();
        }
        return names;
    }

    @Override
    public String[] getTargetTransformNames() {
        List<IStream> targetStreams = this.getTargetStreams();
        String[] names = new String[targetStreams.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = targetStreams.get(i).getTransformName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInfoTransforms(TransformMeta[] infoTransforms) {
        ArrayList<IStream> list = new ArrayList<IStream>();
        List<IStream> list2 = this.streams;
        synchronized (list2) {
            for (IStream stream : this.streams) {
                if (!stream.getStreamType().equals((Object)IStream.StreamType.INFO)) continue;
                list.add(stream);
            }
        }
        for (int i = 0; i < infoTransforms.length; ++i) {
            if (i >= list.size()) {
                throw new RuntimeException("We expect all possible info streams to be pre-populated!");
            }
            this.streams.get(i).setTransformMeta(infoTransforms[i]);
        }
    }

    @Override
    public String getGeneralInfoDescription() {
        return this.generalInfoDescription;
    }

    @Override
    public void setGeneralInfoDescription(String generalInfoDescription) {
        this.generalInfoDescription = generalInfoDescription;
    }

    @Override
    public String getGeneralTargetDescription() {
        return this.generalTargetDescription;
    }

    @Override
    public void setGeneralTargetDescription(String generalTargetDescription) {
        this.generalTargetDescription = generalTargetDescription;
    }

    public void clearStreams() {
        this.streams.clear();
    }

    @Override
    public boolean isOutputDynamic() {
        return this.outputDynamic;
    }

    @Override
    public void setOutputDynamic(boolean outputDynamic) {
        this.outputDynamic = outputDynamic;
    }

    @Override
    public boolean isInputDynamic() {
        return this.inputDynamic;
    }

    @Override
    public void setInputDynamic(boolean inputDynamic) {
        this.inputDynamic = inputDynamic;
    }

    @Override
    public IStream findTargetStream(TransformMeta targetTransform) {
        for (IStream stream : this.getTargetStreams()) {
            if (!targetTransform.equals(stream.getTransformMeta())) continue;
            return stream;
        }
        return null;
    }

    @Override
    public IStream findInfoStream(TransformMeta infoTransform) {
        for (IStream stream : this.getInfoStreams()) {
            if (!infoTransform.equals(stream.getTransformMeta())) continue;
            return stream;
        }
        return null;
    }
}

