/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.Date;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.Metrics;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;

public class RunThread
implements Runnable {
    private static final Class<?> PKG = BaseTransform.class;
    private ITransform transform;
    private ILogChannel log;

    public RunThread(TransformMetaDataCombi combi) {
        this.transform = combi.transform;
        this.transform.setMeta(combi.meta);
        this.transform.setData(combi.data);
        this.log = this.transform.getLogChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block35: {
            this.transform.setRunning(true);
            this.transform.setExecutionStartDate(new Date());
            this.transform.getLogChannel().snap((IMetrics)Metrics.METRIC_TRANSFORM_EXECUTION_START, new long[0]);
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString((String)"System.Log.StartingToRun"));
            }
            while (this.transform.processRow() && !this.transform.isStopped()) {
            }
            this.transform.dispose();
            this.transform.setExecutionEndDate(new Date());
            if (this.transform.getLastRowWrittenDate() != null) break block35;
            this.transform.setLastRowWrittenDate(this.transform.getExecutionEndDate());
        }
        this.transform.getLogChannel().snap((IMetrics)Metrics.METRIC_TRANSFORM_EXECUTION_STOP, new long[0]);
        try {
            long li = this.transform.getLinesInput();
            long lo = this.transform.getLinesOutput();
            long lr = this.transform.getLinesRead();
            long lw = this.transform.getLinesWritten();
            long lu = this.transform.getLinesUpdated();
            long lj = this.transform.getLinesRejected();
            long e = this.transform.getErrors();
            if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
            }
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
        }
        catch (Throwable t) {
            this.log.logError("UnexpectedError: " + Const.getStackTracker((Throwable)t));
        }
        finally {
            this.transform.markStop();
        }
        catch (Throwable t) {
            block37: {
                try {
                    try {
                        if (t instanceof OutOfMemoryError) {
                            this.log.logError("UnexpectedError: ", t);
                        } else {
                            t.printStackTrace();
                            this.log.logError(BaseMessages.getString((String)"System.Log.UnexpectedError"), t);
                        }
                        String logChannelId = this.log.getLogChannelId();
                        ILoggingObject loggingObject = LoggingRegistry.getInstance().getLoggingObject(logChannelId);
                        String parentLogChannelId = loggingObject.getParent().getLogChannelId();
                        List logChannelChildren = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
                        int childIndex = Const.indexOfString((String)this.log.getLogChannelId(), (List)logChannelChildren);
                        if (this.log.isDebug()) {
                            this.log.logDebug("child index = " + childIndex + ", logging object : " + loggingObject.toString() + " parent=" + parentLogChannelId);
                        }
                        HopLogStore.getAppender().getBuffer("2bcc6b3f-c660-4a8b-8b17-89e8cbd5b29b", false);
                    }
                    catch (OutOfMemoryError e) {
                        e.printStackTrace();
                    }
                    finally {
                        this.transform.setErrors(1L);
                        this.transform.stopAll();
                    }
                    this.transform.dispose();
                    this.transform.setExecutionEndDate(new Date());
                    if (this.transform.getLastRowWrittenDate() != null) break block37;
                    this.transform.setLastRowWrittenDate(this.transform.getExecutionEndDate());
                }
                catch (Throwable throwable) {
                    this.transform.dispose();
                    this.transform.setExecutionEndDate(new Date());
                    if (this.transform.getLastRowWrittenDate() == null) {
                        this.transform.setLastRowWrittenDate(this.transform.getExecutionEndDate());
                    }
                    this.transform.getLogChannel().snap((IMetrics)Metrics.METRIC_TRANSFORM_EXECUTION_STOP, new long[0]);
                    try {
                        long li = this.transform.getLinesInput();
                        long lo = this.transform.getLinesOutput();
                        long lr = this.transform.getLinesRead();
                        long lw = this.transform.getLinesWritten();
                        long lu = this.transform.getLinesUpdated();
                        long lj = this.transform.getLinesRejected();
                        long e = this.transform.getErrors();
                        if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                            this.log.logBasic(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                        } else {
                            this.log.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                        }
                    }
                    catch (Throwable t2) {
                        this.log.logError("UnexpectedError: " + Const.getStackTracker((Throwable)t2));
                    }
                    finally {
                        this.transform.markStop();
                    }
                    throw throwable;
                }
            }
            this.transform.getLogChannel().snap((IMetrics)Metrics.METRIC_TRANSFORM_EXECUTION_STOP, new long[0]);
            try {
                long li = this.transform.getLinesInput();
                long lo = this.transform.getLinesOutput();
                long lr = this.transform.getLinesRead();
                long lw = this.transform.getLinesWritten();
                long lu = this.transform.getLinesUpdated();
                long lj = this.transform.getLinesRejected();
                long e = this.transform.getErrors();
                if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                } else {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
                }
            }
            catch (Throwable t3) {
                this.log.logError("UnexpectedError: " + Const.getStackTracker((Throwable)t3));
            }
            finally {
                this.transform.markStop();
            }
        }
    }
}

