/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.IHopAttribute;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transform.errorhandling.Stream;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceReference;
import org.w3c.dom.Node;

public class BaseTransformMeta
implements Cloneable {
    public static final ILoggingObject loggingObject = new SimpleLoggingObject("Transform metadata", LoggingObjectType.TRANSFORM_META, null);
    private boolean changed = false;
    protected Database[] databases;
    protected TransformMeta parentTransformMeta;
    private volatile ITransformIOMeta ioMetaVar;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected ILogChannel log;
    protected ArrayList<IHopAttribute> attributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            BaseTransformMeta retval = (BaseTransformMeta)super.clone();
            this.lock.readLock().lock();
            try {
                if (this.ioMetaVar != null) {
                    TransformIOMeta transformIOMeta = new TransformIOMeta(this.ioMetaVar.isInputAcceptor(), this.ioMetaVar.isOutputProducer(), this.ioMetaVar.isInputOptional(), this.ioMetaVar.isSortedDataRequired(), this.ioMetaVar.isInputDynamic(), this.ioMetaVar.isOutputDynamic());
                    List<IStream> infoStreams = this.ioMetaVar.getInfoStreams();
                    for (IStream infoStream : infoStreams) {
                        transformIOMeta.addStream(new Stream(infoStream));
                    }
                    List<IStream> targetStreams = this.ioMetaVar.getTargetStreams();
                    for (IStream targetStream : targetStreams) {
                        transformIOMeta.addStream(new Stream(targetStream));
                    }
                    this.lock.readLock().unlock();
                    retval.setTransformIOMeta(transformIOMeta);
                    this.lock.readLock().lock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setDefault() {
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public void setChanged() {
        this.changed = true;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public IRowMeta getTableFields(IVariables variables) {
        return null;
    }

    public String getXml() throws HopException {
        this.convertIOMetaToTransformNames();
        return XmlMetadataUtil.serializeObjectToXml((Object)this);
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        XmlMetadataUtil.deSerializeFromXml((Node)transformNode, this.getClass(), (Object)this, (IHopMetadataProvider)metadataProvider);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        return new SqlStatement(transformMeta.getName(), null, null);
    }

    public void cancelQueries() throws HopDatabaseException {
        if (this.databases != null) {
            for (int i = 0; i < this.databases.length; ++i) {
                if (this.databases[i] == null) continue;
                this.databases[i].cancelQuery();
            }
        }
    }

    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        return new RowMeta();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[0];
    }

    public boolean supportsErrorHandling() {
        return false;
    }

    public boolean excludeFromRowLayoutVerification() {
        return false;
    }

    public boolean excludeFromCopyDistributeVerification() {
        return false;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, TransformMeta transformMeta) {
        return Arrays.asList(new ResourceReference(transformMeta));
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        return null;
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        if (className.endsWith("Meta")) {
            className = className.substring(0, className.length() - 4);
        }
        className = className + "Dialog";
        try {
            Class<?> clazz = Class.forName(className.replaceFirst("\\.hop\\.", ".hop.ui."));
            className = clazz.getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return className;
    }

    public TransformMeta getParentTransformMeta() {
        return this.parentTransformMeta;
    }

    public void setParentTransformMeta(TransformMeta parentTransformMeta) {
        this.parentTransformMeta = parentTransformMeta;
    }

    public ILogChannel getLog() {
        if (this.log == null) {
            this.log = new LogChannel((Object)this);
        }
        return this.log;
    }

    public boolean isBasic() {
        return this.getLog().isBasic();
    }

    public boolean isDetailed() {
        return this.getLog().isDetailed();
    }

    public boolean isDebug() {
        return this.getLog().isDebug();
    }

    public boolean isRowLevel() {
        return this.getLog().isRowLevel();
    }

    public void logMinimal(String message) {
        this.getLog().logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.getLog().logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.getLog().logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.getLog().logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.getLog().logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.getLog().logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.getLog().logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.getLog().logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.getLog().logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.getLog().logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.getLog().logError(message);
    }

    public void logError(String message, Throwable e) {
        this.getLog().logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.getLog().logError(message, arguments);
    }

    public String getLogChannelId() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getObjectCopy() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return null;
    }

    public ILoggingObject getParent() {
        return null;
    }

    public ITransformIOMeta getTransformIOMeta() {
        return this.getTransformIOMeta(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransformIOMeta getTransformIOMeta(boolean createIfAbsent) {
        ITransformIOMeta ioMeta = null;
        this.lock.readLock().lock();
        try {
            if (this.ioMetaVar == null && createIfAbsent) {
                ioMeta = new TransformIOMeta(true, true, true, false, false, false);
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    this.ioMetaVar = ioMeta;
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            } else {
                ioMeta = this.ioMetaVar;
            }
            ITransformIOMeta iTransformIOMeta = ioMeta;
            return iTransformIOMeta;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setTransformIOMeta(ITransformIOMeta value) {
        this.lock.writeLock().lock();
        try {
            this.ioMetaVar = value;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public List<IStream> getOptionalStreams() {
        ArrayList<IStream> list = new ArrayList<IStream>();
        return list;
    }

    public void handleStreamSelection(IStream stream) {
    }

    public void resetTransformIoMeta() {
        this.lock.writeLock().lock();
        try {
            this.ioMetaVar = null;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
    }

    public void convertIOMetaToTransformNames() {
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal, PipelineMeta.PipelineType.SingleThreaded};
    }

    public String[] getReferencedObjectDescriptions() {
        return null;
    }

    public boolean[] isReferencedObjectEnabled() {
        return null;
    }

    public String getActiveReferencedObjectDescription() {
        return null;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return null;
    }
}

