/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engine;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.IExtensionData;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.IExecutionFinishedListener;
import org.apache.hop.pipeline.IExecutionStartedListener;
import org.apache.hop.pipeline.IExecutionStoppedListener;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.EngineMetrics;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineComponentRowsReceived;
import org.apache.hop.pipeline.engine.PipelineEngineCapabilities;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public interface IPipelineEngine<T extends PipelineMeta>
extends IVariables,
ILoggingObject,
INamedParameters,
IExtensionData {
    public T getPipelineMeta();

    public void setPipelineMeta(T var1);

    public String getPluginId();

    public void setPluginId(String var1);

    public IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration();

    public void setPipelineRunConfiguration(PipelineRunConfiguration var1);

    public PipelineRunConfiguration getPipelineRunConfiguration();

    public PipelineEngineCapabilities getEngineCapabilities();

    public void execute() throws HopException;

    public void prepareExecution() throws HopException;

    public boolean isPreparing();

    public boolean isReadyToStart();

    public void startThreads() throws HopException;

    public EngineMetrics getEngineMetrics();

    public EngineMetrics getEngineMetrics(String var1, int var2);

    public void cleanup();

    public void waitUntilFinished();

    public void stopAll();

    public boolean hasHaltedComponents();

    public boolean isRunning();

    public boolean isStopped();

    public void pauseExecution();

    public void resumeExecution();

    public int getErrors();

    public boolean isFinished();

    public boolean isPaused();

    public void addExecutionStartedListener(IExecutionStartedListener<IPipelineEngine<T>> var1) throws HopException;

    public void firePipelineExecutionStartedListeners() throws HopException;

    public void addExecutionFinishedListener(IExecutionFinishedListener<IPipelineEngine<T>> var1) throws HopException;

    public void firePipelineExecutionFinishedListeners() throws HopException;

    public void addExecutionStoppedListener(IExecutionStoppedListener<IPipelineEngine<T>> var1) throws HopException;

    public void firePipelineExecutionStoppedListeners() throws HopException;

    public String getComponentLogText(String var1, int var2);

    public List<IEngineComponent> getComponents();

    public List<IEngineComponent> getComponentCopies(String var1);

    public IEngineComponent findComponent(String var1, int var2);

    public ILogChannel getLogChannel();

    public void setLogChannel(ILogChannel var1);

    public String getLogChannelId();

    public void setParent(ILoggingObject var1);

    public void setParentWorkflow(IWorkflowEngine<WorkflowMeta> var1);

    public void setParentPipeline(IPipelineEngine var1);

    public void setPreviousResult(Result var1);

    public Result getResult();

    public void setMetadataProvider(IHopMetadataProvider var1);

    public IHopMetadataProvider getMetadataProvider();

    public void setLogLevel(LogLevel var1);

    public LogLevel getLogLevel();

    @Deprecated
    public void setPreview(boolean var1);

    @Deprecated
    public boolean isPreview();

    public void retrieveComponentOutput(IVariables var1, String var2, int var3, int var4, IPipelineComponentRowsReceived var5) throws HopException;

    public IPipelineEngine<T> getParentPipeline();

    public IWorkflowEngine<WorkflowMeta> getParentWorkflow();

    public boolean isSafeModeEnabled();

    public IRowSet findRowSet(String var1, int var2, String var3, int var4);

    @Deprecated
    public boolean isFeedbackShown();

    @Deprecated
    public int getFeedbackSize();

    public Result getPreviousResult();

    public Date getExecutionStartDate();

    public Date getExecutionEndDate();

    public void addActiveSubPipeline(String var1, IPipelineEngine var2);

    public IPipelineEngine getActiveSubPipeline(String var1);

    public void addActiveSubWorkflow(String var1, IWorkflowEngine<WorkflowMeta> var2);

    public IWorkflowEngine<WorkflowMeta> getActiveSubWorkflow(String var1);

    public void setInternalHopVariables(IVariables var1);

    public void setContainerId(String var1);

    public String getStatusDescription();

    public Map<String, Object> getExtensionDataMap();
}

