/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engine;

import java.util.Date;
import java.util.Objects;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowListener;

public class EngineComponent
implements IEngineComponent {
    private static final Class<?> PKG = BaseTransform.class;
    private String name;
    private int copyNr;
    private String logChannelId;
    private ILogChannel logChannel;
    private LogLevel logLevel;
    private String logText;
    private boolean running;
    private boolean selected;
    private long errors;
    private long linesRead;
    private long linesWritten;
    private long linesInput;
    private long linesOutput;
    private long linesRejected;
    private long linesUpdated;
    private long executionDuration;
    private long inputBufferSize;
    private long outputBufferSize;
    private boolean stopped;
    private boolean paused;
    private ComponentExecutionStatus status;
    private Date initStartDate;
    private Date executionStartDate;
    private Date firstRowReadDate;
    private Date lastRowWrittenDate;
    private Date executionEndDate;

    public EngineComponent() {
    }

    public EngineComponent(String name, int copyNr) {
        this();
        this.name = name;
        this.copyNr = copyNr;
        this.logChannel = LogChannel.GENERAL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineComponent that = (EngineComponent)o;
        return this.copyNr == that.copyNr && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.copyNr);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getCopyNr() {
        return this.copyNr;
    }

    public void setCopyNr(int copyNr) {
        this.copyNr = copyNr;
    }

    @Override
    public ILogChannel getLogChannel() {
        return this.logChannel;
    }

    public void setLogChannel(ILogChannel logChannel) {
        this.logChannel = logChannel;
    }

    @Override
    public String getLogChannelId() {
        return this.logChannelId;
    }

    public void setLogChannelId(String logChannelId) {
        this.logChannelId = logChannelId;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String getLogText() {
        return this.logText;
    }

    public void setLogText(String logText) {
        this.logText = logText;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public long getErrors() {
        return this.errors;
    }

    @Override
    public void addRowListener(IRowListener rowListener) {
        throw new RuntimeException("Adding a row listener to this transform is not possible as it's not part of a running engine");
    }

    @Override
    public void removeRowListener(IRowListener rowListener) {
        throw new RuntimeException("Removing a row listener to this transform is not possible as it's not part of a running engine");
    }

    public void setErrors(long errors) {
        this.errors = errors;
    }

    @Override
    public long getLinesRead() {
        return this.linesRead;
    }

    public void setLinesRead(long linesRead) {
        this.linesRead = linesRead;
    }

    @Override
    public long getLinesWritten() {
        return this.linesWritten;
    }

    public void setLinesWritten(long linesWritten) {
        this.linesWritten = linesWritten;
    }

    @Override
    public long getLinesInput() {
        return this.linesInput;
    }

    public void setLinesInput(long linesInput) {
        this.linesInput = linesInput;
    }

    @Override
    public long getLinesOutput() {
        return this.linesOutput;
    }

    public void setLinesOutput(long linesOutput) {
        this.linesOutput = linesOutput;
    }

    @Override
    public long getLinesRejected() {
        return this.linesRejected;
    }

    public void setLinesRejected(long linesRejected) {
        this.linesRejected = linesRejected;
    }

    @Override
    public long getLinesUpdated() {
        return this.linesUpdated;
    }

    public void setLinesUpdated(long linesUpdated) {
        this.linesUpdated = linesUpdated;
    }

    @Override
    public String getStatusDescription() {
        return this.status == null ? null : this.status.getDescription();
    }

    @Override
    public long getExecutionDuration() {
        return this.executionDuration;
    }

    public void setExecutionDuration(long executionDuration) {
        this.executionDuration = executionDuration;
    }

    @Override
    public long getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(long inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @Override
    public long getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(long outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Override
    public ComponentExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(ComponentExecutionStatus status) {
        this.status = status;
    }

    @Override
    public Date getInitStartDate() {
        return this.initStartDate;
    }

    @Override
    public void setInitStartDate(Date initStartDate) {
        this.initStartDate = initStartDate;
    }

    @Override
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    @Override
    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    @Override
    public Date getFirstRowReadDate() {
        return this.firstRowReadDate;
    }

    @Override
    public void setFirstRowReadDate(Date firstRowReadDate) {
        this.firstRowReadDate = firstRowReadDate;
    }

    @Override
    public Date getLastRowWrittenDate() {
        return this.lastRowWrittenDate;
    }

    @Override
    public void setLastRowWrittenDate(Date lastRowWrittenDate) {
        this.lastRowWrittenDate = lastRowWrittenDate;
    }

    @Override
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    @Override
    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }

    static /* synthetic */ Class access$000() {
        return PKG;
    }

    public static enum ComponentExecutionStatus {
        STATUS_EMPTY(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Empty", (String[])new String[0])),
        STATUS_INIT(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Init", (String[])new String[0])),
        STATUS_RUNNING(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Running", (String[])new String[0])),
        STATUS_IDLE(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Idle", (String[])new String[0])),
        STATUS_FINISHED(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Finished", (String[])new String[0])),
        STATUS_STOPPED(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Stopped", (String[])new String[0])),
        STATUS_DISPOSED(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Disposed", (String[])new String[0])),
        STATUS_HALTED(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Halted", (String[])new String[0])),
        STATUS_PAUSED(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Paused", (String[])new String[0])),
        STATUS_HALTING(BaseMessages.getString((Class)EngineComponent.access$000(), (String)"BaseTransform.status.Halting", (String[])new String[0]));

        private String description;

        private ComponentExecutionStatus(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description;
        }

        public static ComponentExecutionStatus getStatusFromDescription(String description) {
            for (ComponentExecutionStatus status : ComponentExecutionStatus.values()) {
                if (!status.description.equalsIgnoreCase(description)) continue;
                return status;
            }
            return STATUS_EMPTY;
        }
    }
}

