/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.VariableValueDescription;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;

@HopMetadata(key="pipeline-run-configuration", name="Pipeline Run Configuration", description="Describes how and with which engine a pipeline is to be executed", image="ui/images/pipeline_run_config.svg", documentationUrl="/metadata-types/pipeline-run-config.html")
public class PipelineRunConfiguration
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    public static final String GUI_PLUGIN_ELEMENT_PARENT_ID = "PipelineRunConfiguration-PluginSpecific-Options";
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty
    private List<VariableValueDescription> configurationVariables;
    @HopMetadataProperty
    private IPipelineEngineRunConfiguration engineRunConfiguration;

    public PipelineRunConfiguration() {
        this.configurationVariables = new ArrayList<VariableValueDescription>();
    }

    public PipelineRunConfiguration(String name, String description, List<VariableValueDescription> configurationVariables, IPipelineEngineRunConfiguration engineRunConfiguration) {
        this.name = name;
        this.description = description;
        this.configurationVariables = configurationVariables;
        this.engineRunConfiguration = engineRunConfiguration;
    }

    public PipelineRunConfiguration(PipelineRunConfiguration runConfiguration) {
        this();
        this.name = runConfiguration.name;
        this.description = runConfiguration.description;
        this.configurationVariables.addAll(runConfiguration.getConfigurationVariables());
        if (runConfiguration.getEngineRunConfiguration() != null) {
            this.engineRunConfiguration = runConfiguration.engineRunConfiguration.clone();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<VariableValueDescription> getConfigurationVariables() {
        return this.configurationVariables;
    }

    public void setConfigurationVariables(List<VariableValueDescription> configurationVariables) {
        this.configurationVariables = configurationVariables;
    }

    public IPipelineEngineRunConfiguration getEngineRunConfiguration() {
        return this.engineRunConfiguration;
    }

    public void setEngineRunConfiguration(IPipelineEngineRunConfiguration engineRunConfiguration) {
        this.engineRunConfiguration = engineRunConfiguration;
    }

    public void applyToVariables(IVariables variables) {
        for (VariableValueDescription vvd : this.configurationVariables) {
            if (!StringUtils.isNotEmpty((String)vvd.getName())) continue;
            variables.setVariable(vvd.getName(), variables.resolve(vvd.getValue()));
        }
    }
}

