/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.pipeline.transform.errorhandling.IStream;

public class SingleThreadedPipelineExecutor {
    private final List<TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData>> transforms;
    private Pipeline pipeline;
    private boolean[] done;
    private int nrDone;
    private List<List<IStream>> transformInfoStreams;
    private List<List<IRowSet>> transformInfoRowSets;
    private ILogChannel log;

    public SingleThreadedPipelineExecutor(Pipeline pipeline) {
        this.pipeline = pipeline;
        this.log = pipeline.getLogChannel();
        this.transforms = pipeline.getTransforms();
        this.sortTransforms();
        this.done = new boolean[this.transforms.size()];
        this.nrDone = 0;
        this.transformInfoStreams = new ArrayList<List<IStream>>();
        this.transformInfoRowSets = new ArrayList<List<IRowSet>>();
        for (TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> combi : this.transforms) {
            List<IStream> infoStreams = combi.transformMeta.getTransform().getTransformIOMeta().getInfoStreams();
            this.transformInfoStreams.add(infoStreams);
            ArrayList<IRowSet> infoRowSets = new ArrayList<IRowSet>();
            for (IStream infoStream : infoStreams) {
                IRowSet infoRowSet = pipeline.findRowSet(infoStream.getTransformName(), 0, combi.transformName, 0);
                if (infoRowSet == null) continue;
                infoRowSets.add(infoRowSet);
            }
            this.transformInfoRowSets.add(infoRowSets);
        }
    }

    private void sortTransforms() {
        this.pipeline.getPipelineMeta().clearCaches();
        boolean testing = true;
        int transformsMinSize = 0;
        int transformsSize = this.transforms.size();
        int windowShrinkThreshold = (int)Math.round((double)transformsSize * 0.75);
        int totalIterations = transformsSize * 2;
        int actualIterations = 0;
        boolean isBefore = false;
        boolean forwardChange = false;
        boolean backwardChange = false;
        boolean lastForwardChange = true;
        boolean keepSortingForward = true;
        TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> one = null;
        TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> two = null;
        StringBuilder tLogString = new StringBuilder();
        tLogString.append("-------------------------------------------------------").append("\n");
        tLogString.append("--SingleThreadedPipelineExecutor.sortTransforms(cocktail)").append("\n");
        tLogString.append("--Pipeline: ").append(this.pipeline.getName()).append("\n");
        tLogString.append("-").append("\n");
        long startTime = System.currentTimeMillis();
        for (int x = 0; x < totalIterations; ++x) {
            if (keepSortingForward) {
                for (int y = transformsMinSize; y < transformsSize - 1; ++y) {
                    one = this.transforms.get(y);
                    two = this.transforms.get(y + 1);
                    isBefore = this.pipeline.getPipelineMeta().findPrevious(one.transformMeta, two.transformMeta);
                    if (!isBefore) continue;
                    this.transforms.set(y, two);
                    this.transforms.set(y + 1, one);
                    forwardChange = true;
                }
            }
            for (int z = transformsSize - 1; z > transformsMinSize; --z) {
                one = this.transforms.get(z);
                two = this.transforms.get(z - 1);
                isBefore = this.pipeline.getPipelineMeta().findPrevious(one.transformMeta, two.transformMeta);
                if (isBefore) continue;
                this.transforms.set(z, two);
                this.transforms.set(z - 1, one);
                backwardChange = true;
            }
            if (x > windowShrinkThreshold && !forwardChange && --transformsSize <= transformsMinSize) {
                if (!testing) break;
                tLogString.append(String.format("transformsMinSize:%s  transformsSize:%s", transformsMinSize, transformsSize));
                tLogString.append("transformsSize is <= transformsMinSize.. exiting outer sort loop. index:" + x).append("\n");
                break;
            }
            if (x > windowShrinkThreshold && !backwardChange && ++transformsMinSize >= transformsSize) {
                if (!testing) break;
                tLogString.append(String.format("transformsMinSize:%s  transformsSize:%s", transformsMinSize, transformsSize)).append("\n");
                tLogString.append("transformsMinSize is >= transformsSize.. exiting outer sort loop. index:" + x).append("\n");
                break;
            }
            ++actualIterations;
            if (!forwardChange && !backwardChange) {
                if (!testing) break;
                tLogString.append(String.format("existing outer loop because no change was detected going forward or backward. index:%s  min:%s  max:%s", x, transformsMinSize, transformsSize)).append("\n");
                break;
            }
            if (keepSortingForward && x > 0 && !lastForwardChange && !forwardChange) {
                keepSortingForward = false;
            }
            lastForwardChange = forwardChange;
            forwardChange = false;
            backwardChange = false;
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        tLogString.append("-------------------------------------------------------").append("\n");
        tLogString.append("Transforms sort time: " + totalTime + "ms").append("\n");
        tLogString.append("Total iterations: " + actualIterations).append("\n");
        tLogString.append("Transform count: " + this.transforms.size()).append("\n");
        tLogString.append("Transforms after sort: ").append("\n");
        for (TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> combi : this.transforms) {
            tLogString.append(combi.transform.getTransformName()).append("\n");
        }
        tLogString.append("-------------------------------------------------------").append("\n");
        if (this.log.isDetailed()) {
            this.log.logDetailed(tLogString.toString());
        }
    }

    public boolean init() throws HopException {
        for (TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> combi : this.transforms) {
            boolean ok = combi.transform.init();
            if (ok) continue;
            return false;
        }
        return true;
    }

    public boolean oneIteration() throws HopException {
        for (int s = 0; s < this.transforms.size() && !this.pipeline.isStopped(); ++s) {
            if (this.done[s]) continue;
            TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> combi = this.transforms.get(s);
            boolean transformDone = false;
            List<IRowSet> infoRowSets = this.transformInfoRowSets.get(s);
            for (IRowSet rowSet : infoRowSets) {
                boolean once = true;
                while (once || rowSet.size() > 0 && !transformDone) {
                    once = false;
                    boolean bl = transformDone = !combi.transform.processRow();
                    if (combi.transform.getErrors() <= 0L) continue;
                    return false;
                }
            }
            List<IRowSet> rowSets = combi.transform.getInputRowSets();
            if (rowSets.size() == 0) {
                while (!transformDone && !this.pipeline.isStopped()) {
                    boolean bl = transformDone = !combi.transform.processRow();
                    if (combi.transform.getErrors() <= 0L) continue;
                    return false;
                }
            } else {
                int nrRows = 0;
                for (IRowSet rowSet : rowSets) {
                    nrRows += rowSet.size();
                }
                for (int i = 0; i < nrRows; ++i) {
                    boolean bl = transformDone = !combi.transform.processRow();
                    if (combi.transform.getErrors() <= 0L) continue;
                    return false;
                }
            }
            combi.transform.batchComplete();
            if (transformDone) {
                ++this.nrDone;
            }
            this.done[s] = transformDone;
        }
        return this.nrDone < this.transforms.size() && !this.pipeline.isStopped();
    }

    protected int getTotalRows(List<IRowSet> rowSets) {
        int total = 0;
        for (IRowSet rowSet : rowSets) {
            total += rowSet.size();
        }
        return total;
    }

    public long getErrors() {
        return this.pipeline.getErrors();
    }

    public Result getResult() {
        return this.pipeline.getResult();
    }

    public boolean isStopped() {
        return this.pipeline.isStopped();
    }

    public void dispose() throws HopException {
        for (TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> combi : this.pipeline.getTransforms()) {
            combi.transform.setOutputDone();
        }
        for (TransformMetaDataCombi<ITransform, ITransformMeta, ITransformData> combi : this.transforms) {
            combi.transform.dispose();
            combi.transform.markStop();
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void clearError() {
        this.pipeline.clearError();
    }
}

