/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import org.apache.hop.core.annotations.PartitionerPlugin;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.BasePartitioner;
import org.apache.hop.pipeline.IPartitioner;
import org.w3c.dom.Node;

@PartitionerPlugin(id="ModPartitioner", name="Remainder of division", description="Mod")
public class ModPartitioner
extends BasePartitioner {
    private String fieldName;
    protected int partitionColumnIndex = -1;

    @Override
    public IPartitioner getInstance() {
        ModPartitioner partitioner = new ModPartitioner();
        partitioner.setId(this.getId());
        partitioner.setDescription(this.getDescription());
        return partitioner;
    }

    @Override
    public ModPartitioner clone() {
        ModPartitioner modPartitioner = (ModPartitioner)super.clone();
        modPartitioner.fieldName = this.fieldName;
        return modPartitioner;
    }

    @Override
    public String getDialogClassName() {
        return "org.apache.hop.ui.pipeline.dialog.ModPartitionerDialog";
    }

    @Override
    public int getPartition(IVariables variables, IRowMeta rowMeta, Object[] row) throws HopException {
        long value;
        if (rowMeta == null) {
            throw new HopException("No row metadata was provided and so a partition can't be calculated on field '" + this.fieldName + "' using a mod partitioner");
        }
        this.init(variables, rowMeta);
        if (this.partitionColumnIndex < 0) {
            this.partitionColumnIndex = rowMeta.indexOfValue(this.fieldName);
            if (this.partitionColumnIndex < 0) {
                throw new HopTransformException("Unable to find partitioning field name [" + this.fieldName + "] in the output row..." + rowMeta);
            }
        }
        IValueMeta valueMeta = rowMeta.getValueMeta(this.partitionColumnIndex);
        Object valueData = row[this.partitionColumnIndex];
        switch (valueMeta.getType()) {
            case 5: {
                Long longValue = rowMeta.getInteger(row, this.partitionColumnIndex);
                if (longValue == null) {
                    value = valueMeta.hashCode(valueData);
                    break;
                }
                value = longValue;
                break;
            }
            default: {
                value = valueMeta.hashCode(valueData);
            }
        }
        int targetLocation = (int)(Math.abs(value) % (long)this.nrPartitions);
        return targetLocation;
    }

    @Override
    public String getDescription() {
        String description = "Mod partitioner";
        if (!Utils.isEmpty((CharSequence)this.fieldName)) {
            description = description + "(" + this.fieldName + ")";
        }
        return description;
    }

    @Override
    public String getXml() {
        StringBuilder xml = new StringBuilder(150);
        xml.append("           ").append(XmlHandler.addTagValue((String)"field_name", (String)this.fieldName));
        return xml.toString();
    }

    @Override
    public void loadXml(Node partitioningMethodNode) throws HopXmlException {
        this.fieldName = XmlHandler.getTagValue((Node)partitioningMethodNode, (String)"field_name");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

