/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.imp;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.imp.IHopImport;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;

public abstract class HopImportBase
implements IHopImport {
    protected ILogChannel log;
    protected IVariables variables = new Variables();
    protected String inputFolderName;
    protected String outputFolderName;
    protected String sharedXmlFilename;
    protected String kettlePropertiesFilename;
    protected String jdbcPropertiesFilename;
    protected boolean skippingExistingTargetFiles;
    protected String targetConfigFilename = "imported-env-conf.json";
    protected boolean skippingHiddenFilesAndFolders;
    protected boolean skippingFolders;
    protected TreeMap<String, String> connectionFileMap;
    protected List<DatabaseMeta> connectionsList;
    protected IVariables collectedVariables;
    protected FileObject inputFolder;
    protected FileObject outputFolder;
    protected HashMap<String, DOMSource> migratedFilesMap;
    protected int connectionCounter;
    protected int variableCounter;
    protected IHopMetadataProvider metadataProvider;
    protected IProgressMonitor monitor;
    protected String metadataTargetFolder;

    public HopImportBase() {
        this.log = LogChannel.GENERAL;
        this.connectionsList = new ArrayList<DatabaseMeta>();
        this.connectionFileMap = new TreeMap();
        this.migratedFilesMap = new HashMap();
        this.collectedVariables = new Variables();
    }

    @Override
    public void init(IVariables variables, ILogChannel log) throws HopException {
        this.variables = variables;
        this.log = log;
    }

    @Override
    public void runImport(IProgressMonitor monitor) throws HopException {
        this.monitor = monitor;
        if (this.metadataProvider == null) {
            this.metadataTargetFolder = this.outputFolder.getName().getURI() + "/metadata";
            this.metadataProvider = new JsonMetadataProvider(Encr.getEncoder(), this.metadataTargetFolder, this.variables);
        }
        if (monitor != null) {
            monitor.setTaskName("Finding files to import");
        }
        this.findFilesToImport();
        if (monitor != null) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            monitor.setTaskName("Importing files");
        }
        this.importFiles();
        if (monitor != null) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            monitor.setTaskName("Importing connections");
        }
        this.importConnections();
        if (monitor != null) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.worked(1);
            monitor.setTaskName("Importing variables");
        }
        this.importVariables();
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    @Override
    public abstract void importFiles() throws HopException;

    public abstract void findFilesToImport() throws HopException;

    @Override
    public abstract void importConnections() throws HopException;

    @Override
    public abstract void importVariables() throws HopException;

    protected void collectVariablesFromKettleProperties() throws HopException {
        try {
            Properties properties = new Properties();
            FileObject varFile = HopVfs.getFileObject((String)this.kettlePropertiesFilename);
            InputStream inputStream = HopVfs.getInputStream((FileObject)varFile);
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                this.collectedVariables.setVariable((String)k, (String)v);
                ++this.variableCounter;
                this.log.logDetailed("Saved variable " + (String)k + ": " + (String)v);
            }));
        }
        catch (Exception e) {
            throw new HopException("Error collecting variables from file " + this.kettlePropertiesFilename, (Throwable)e);
        }
    }

    public void addDatabaseMeta(String filename, DatabaseMeta databaseMeta) throws HopException {
        this.connectionFileMap.put(filename, databaseMeta.getName());
        if (this.connectionsList.stream().filter(dbMeta -> dbMeta.getName().equals(databaseMeta.getName())).collect(Collectors.toList()).size() == 0) {
            this.connectionsList.add(databaseMeta);
            ++this.connectionCounter;
        }
    }

    @Override
    public FileObject getInputFolder() {
        return this.inputFolder;
    }

    @Override
    public void setValidateInputFolder(String inputFolderName) throws HopException {
        try {
            this.inputFolder = HopVfs.getFileObject((String)inputFolderName);
            if (!this.inputFolder.exists() || !this.inputFolder.isFolder()) {
                throw new HopException("input folder '" + inputFolderName + "' doesn't exist or is not a folder.");
            }
            this.inputFolderName = this.inputFolder.getName().getURI();
        }
        catch (Exception e) {
            throw new HopFileException("Error verifying input folder " + inputFolderName, (Throwable)e);
        }
    }

    @Override
    public FileObject getOutputFolder() {
        return this.outputFolder;
    }

    @Override
    public void setValidateOutputFolder(String outputFolderName) throws HopException {
        this.outputFolder = HopVfs.getFileObject((String)outputFolderName);
        try {
            if (!this.outputFolder.exists() || !this.outputFolder.isFolder()) {
                this.log.logBasic("output folder '" + outputFolderName + "' doesn't exist or is not a folder.");
                this.outputFolder.createFolder();
            }
            this.outputFolderName = this.outputFolder.getName().getURI();
        }
        catch (Exception e) {
            throw new HopFileException("Error setting output folder " + outputFolderName, (Throwable)e);
        }
    }

    @Override
    public String getInputFolderName() {
        return this.inputFolderName;
    }

    public void setInputFolderName(String inputFolderName) {
        this.inputFolderName = inputFolderName;
    }

    @Override
    public String getOutputFolderName() {
        return this.outputFolderName;
    }

    public void setOutputFolderName(String outputFolderName) {
        this.outputFolderName = outputFolderName;
    }

    public TreeMap<String, String> getConnectionFileMap() {
        return this.connectionFileMap;
    }

    public void setConnectionFileMap(TreeMap<String, String> connectionFileMap) {
        this.connectionFileMap = connectionFileMap;
    }

    public List<DatabaseMeta> getConnectionsList() {
        return this.connectionsList;
    }

    public void setConnectionsList(List<DatabaseMeta> connectionsList) {
        this.connectionsList = connectionsList;
    }

    public void setInputFolder(FileObject inputFolder) {
        this.inputFolder = inputFolder;
    }

    public void setOutputFolder(FileObject outputFolder) {
        this.outputFolder = outputFolder;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public HashMap<String, DOMSource> getMigratedFilesMap() {
        return this.migratedFilesMap;
    }

    public void setMigratedFilesMap(HashMap<String, DOMSource> migratedFilesMap) {
        this.migratedFilesMap = migratedFilesMap;
    }

    public int getConnectionCounter() {
        return this.connectionCounter;
    }

    public void setConnectionCounter(int connectionCounter) {
        this.connectionCounter = connectionCounter;
    }

    public int getVariableCounter() {
        return this.variableCounter;
    }

    public void setVariableCounter(int variableCounter) {
        this.variableCounter = variableCounter;
    }

    @Override
    public boolean isSkippingExistingTargetFiles() {
        return this.skippingExistingTargetFiles;
    }

    @Override
    public void setSkippingExistingTargetFiles(boolean skippingExistingTargetFiles) {
        this.skippingExistingTargetFiles = skippingExistingTargetFiles;
    }

    @Override
    public String getSharedXmlFilename() {
        return this.sharedXmlFilename;
    }

    @Override
    public void setSharedXmlFilename(String sharedXmlFilename) {
        this.sharedXmlFilename = sharedXmlFilename;
    }

    @Override
    public String getKettlePropertiesFilename() {
        return this.kettlePropertiesFilename;
    }

    @Override
    public void setKettlePropertiesFilename(String kettlePropertiesFilename) {
        this.kettlePropertiesFilename = kettlePropertiesFilename;
    }

    @Override
    public String getJdbcPropertiesFilename() {
        return this.jdbcPropertiesFilename;
    }

    @Override
    public void setJdbcPropertiesFilename(String jdbcPropertiesFilename) {
        this.jdbcPropertiesFilename = jdbcPropertiesFilename;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public String getTargetConfigFilename() {
        return this.targetConfigFilename;
    }

    @Override
    public void setTargetConfigFilename(String targetConfigFilename) {
        this.targetConfigFilename = targetConfigFilename;
    }

    public IVariables getCollectedVariables() {
        return this.collectedVariables;
    }

    public void setCollectedVariables(IVariables collectedVariables) {
        this.collectedVariables = collectedVariables;
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public String getMetadataTargetFolder() {
        return this.metadataTargetFolder;
    }

    public void setMetadataTargetFolder(String metadataTargetFolder) {
        this.metadataTargetFolder = metadataTargetFolder;
    }

    @Override
    public boolean isSkippingHiddenFilesAndFolders() {
        return this.skippingHiddenFilesAndFolders;
    }

    @Override
    public void setSkippingHiddenFilesAndFolders(boolean skippingHiddenFilesAndFolders) {
        this.skippingHiddenFilesAndFolders = skippingHiddenFilesAndFolders;
    }

    @Override
    public boolean isSkippingFolders() {
        return this.skippingFolders;
    }

    @Override
    public void setSkippingFolders(boolean skippingFolders) {
        this.skippingFolders = skippingFolders;
    }

    @Override
    public abstract String getImportReport();
}

