/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.undo;

import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.gui.Point;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.workflow.WorkflowHopMeta;
import org.apache.hop.workflow.action.ActionMeta;

public class ChangeAction {
    private static final Class<?> PKG = ChangeAction.class;
    private ActionType type = ActionType.None;
    private Object[] previous;
    private Point[] previous_location;
    private int[] previousIndex;
    private Object[] current;
    private Point[] current_location;
    private int[] currentIndex;
    private boolean nextAlso;

    public void setDelete(Object[] prev, int[] idx) {
        this.current = prev;
        this.currentIndex = idx;
        if (prev[0] instanceof TransformMeta) {
            this.type = ActionType.DeleteTransform;
        }
        if (prev[0] instanceof PipelineHopMeta) {
            this.type = ActionType.DeleteHop;
        }
        if (prev[0] instanceof NotePadMeta) {
            this.type = ActionType.DeleteNote;
        }
        if (prev[0] instanceof ActionMeta) {
            this.type = ActionType.DeleteAction;
        }
        if (prev[0] instanceof WorkflowHopMeta) {
            this.type = ActionType.DeleteWorkflowHop;
        }
        if (prev[0] instanceof String[]) {
            this.type = ActionType.DeleteTableRow;
        }
    }

    public void setChanged(Object[] prev, Object[] curr, int[] idx) {
        this.previous = prev;
        this.current = curr;
        this.currentIndex = idx;
        this.previousIndex = idx;
        if (prev[0] instanceof TransformMeta) {
            this.type = ActionType.ChangeTransform;
        }
        if (prev[0] instanceof PipelineHopMeta) {
            this.type = ActionType.ChangeHop;
        }
        if (prev[0] instanceof NotePadMeta) {
            this.type = ActionType.ChangeNote;
        }
        if (prev[0] instanceof ActionMeta) {
            this.type = ActionType.ChangeAction;
        }
        if (prev[0] instanceof WorkflowHopMeta) {
            this.type = ActionType.ChangeWorkflowHop;
        }
        if (prev[0] instanceof String[]) {
            this.type = ActionType.ChangeTableRow;
        }
    }

    public void setNew(Object[] prev, int[] position) {
        if (prev.length == 0) {
            return;
        }
        this.current = prev;
        this.currentIndex = position;
        this.previous = null;
        if (prev[0] instanceof TransformMeta) {
            this.type = ActionType.NewTransform;
        }
        if (prev[0] instanceof PipelineHopMeta) {
            this.type = ActionType.NewHop;
        }
        if (prev[0] instanceof NotePadMeta) {
            this.type = ActionType.NewNote;
        }
        if (prev[0] instanceof ActionMeta) {
            this.type = ActionType.NewAction;
        }
        if (prev[0] instanceof WorkflowHopMeta) {
            this.type = ActionType.NewWorkflowHop;
        }
        if (prev[0] instanceof String[]) {
            this.type = ActionType.NewTableRow;
        }
    }

    public void setPosition(Object[] obj, int[] idx, Point[] prev, Point[] curr) {
        if (prev.length != curr.length) {
            return;
        }
        this.previous_location = new Point[prev.length];
        this.current_location = new Point[curr.length];
        this.current = obj;
        this.currentIndex = idx;
        for (int i = 0; i < prev.length; ++i) {
            this.previous_location[i] = new Point(prev[i].x, prev[i].y);
            this.current_location[i] = new Point(curr[i].x, curr[i].y);
        }
        Object fobj = obj[0];
        if (fobj instanceof TransformMeta) {
            this.type = ActionType.PositionTransform;
        }
        if (fobj instanceof NotePadMeta) {
            this.type = ActionType.PositionNote;
        }
        if (fobj instanceof ActionMeta) {
            this.type = ActionType.PositionAction;
        }
    }

    public void setItemMove(int[] prev, int[] curr) {
        this.previous_location = null;
        this.current_location = null;
        this.current = null;
        this.currentIndex = curr;
        this.previous = null;
        this.previousIndex = prev;
        this.type = ActionType.PositionTableRow;
    }

    public ActionType getType() {
        return this.type;
    }

    public Object[] getPrevious() {
        return this.previous;
    }

    public Object[] getCurrent() {
        return this.current;
    }

    public Point[] getPreviousLocation() {
        return this.previous_location;
    }

    public Point[] getCurrentLocation() {
        return this.current_location;
    }

    public int[] getPreviousIndex() {
        return this.previousIndex;
    }

    public int[] getCurrentIndex() {
        return this.currentIndex;
    }

    public void setNextAlso(boolean nextAlso) {
        this.nextAlso = nextAlso;
    }

    public boolean getNextAlso() {
        return this.nextAlso;
    }

    public String toString() {
        String retval = "";
        if (this.type == null) {
            return ChangeAction.class.getName();
        }
        retval = this.type.getDescription();
        if (this.current != null && this.current.length > 1) {
            retval = retval + " (x" + this.current.length + ")";
        }
        return retval;
    }

    static /* synthetic */ Class access$000() {
        return PKG;
    }

    public static enum ActionType {
        None(""),
        ChangeTransform(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.ChangeTransform", (String[])new String[0])),
        ChangeHop(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.ChangeHop", (String[])new String[0])),
        ChangeNote(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.ChangeNote", (String[])new String[0])),
        NewTransform(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.NewTransform", (String[])new String[0])),
        NewHop(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.NewHop", (String[])new String[0])),
        NewNote(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.NewNote", (String[])new String[0])),
        DeleteTransform(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.DeleteTransform", (String[])new String[0])),
        DeleteHop(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.DeleteHop", (String[])new String[0])),
        DeleteNote(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.DeleteNote", (String[])new String[0])),
        PositionTransform(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.PositionTransform", (String[])new String[0])),
        PositionNote(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.PositionNote", (String[])new String[0])),
        ChangeAction(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.ChangeAction", (String[])new String[0])),
        ChangeWorkflowHop(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.ChangeWorkflowHop", (String[])new String[0])),
        NewAction(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.NewAction", (String[])new String[0])),
        NewWorkflowHop(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.NewWorkflowHop", (String[])new String[0])),
        DeleteAction(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.DeleteAction", (String[])new String[0])),
        DeleteWorkflowHop(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.DeleteWorkflowHop", (String[])new String[0])),
        PositionAction(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.PositionAction", (String[])new String[0])),
        ChangeTableRow(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.ChangeTableRow", (String[])new String[0])),
        NewTableRow(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.NewTableRow", (String[])new String[0])),
        DeleteTableRow(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.DeleteTableRow", (String[])new String[0])),
        PositionTableRow(BaseMessages.getString((Class)org.apache.hop.core.undo.ChangeAction.access$000(), (String)"TransAction.label.PositionTableRow", (String[])new String[0]));

        private String description;

        private ActionType(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

