/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.core.variables.VariableValueDescription;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;

@SearchableAnalyserPlugin(id="PipelineRunConfigurationSearchableAnalyser", name="Search in pipeline run configuration metadata")
public class PipelineRunConfigurationSearchableAnalyser
extends BaseMetadataSearchableAnalyser<PipelineRunConfiguration>
implements ISearchableAnalyser<PipelineRunConfiguration> {
    @Override
    public Class<PipelineRunConfiguration> getSearchableClass() {
        return PipelineRunConfiguration.class;
    }

    public List<ISearchResult> search(ISearchable<PipelineRunConfiguration> searchable, ISearchQuery searchQuery) {
        PipelineRunConfiguration runConfig = (PipelineRunConfiguration)searchable.getSearchableObject();
        String component = this.getMetadataComponent();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "Pipeline run configuration name", runConfig.getName(), component);
        this.matchProperty(searchable, results, searchQuery, "Pipeline run configuration description", runConfig.getDescription(), component);
        for (VariableValueDescription configurationVariable : runConfig.getConfigurationVariables()) {
            this.matchProperty(searchable, results, searchQuery, "Pipeline run configuration variable name", configurationVariable.getName(), null);
            this.matchProperty(searchable, results, searchQuery, "Pipeline run configuration variable value", configurationVariable.getValue(), null);
            this.matchProperty(searchable, results, searchQuery, "Pipeline run configuration variable description", configurationVariable.getDescription(), null);
        }
        this.matchObjectFields(searchable, results, searchQuery, runConfig.getEngineRunConfiguration(), "Pipeline run configuration property", null);
        return results;
    }
}

