/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui;

import java.util.List;
import org.apache.hop.base.BaseHopMeta;
import org.apache.hop.base.IBaseMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.IScrollBar;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.Rectangle;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.transform.errorhandling.StreamIcon;

public abstract class BasePainter<Hop extends BaseHopMeta<?>, Part extends IBaseMeta> {
    public final double theta = Math.toRadians(11.0);
    public static final int MINI_ICON_MARGIN = 5;
    public static final int MINI_ICON_TRIANGLE_BASE = 20;
    public static final int MINI_ICON_DISTANCE = 4;
    public static final int MINI_ICON_SKEW = 0;
    public static final int CONTENT_MENU_INDENT = 4;
    public static final int CORNER_RADIUS_5 = 10;
    public static final int CORNER_RADIUS_4 = 8;
    public static final int CORNER_RADIUS_3 = 6;
    public static final int CORNER_RADIUS_2 = 4;
    protected boolean drawingEditIcons;
    protected double zoomFactor;
    protected Point area;
    protected IScrollBar hori;
    protected IScrollBar vert;
    protected List<AreaOwner> areaOwners;
    protected Point offset;
    protected int iconSize;
    protected int miniIconSize;
    protected int gridSize;
    protected Rectangle selectionRectangle;
    protected int lineWidth;
    protected float magnification;
    protected float translationX;
    protected float translationY;
    protected Object subject;
    protected IVariables variables;
    protected IGc gc;
    private String noteFontName;
    private int noteFontHeight;
    protected Hop candidate;

    public BasePainter(IGc gc, IVariables variables, Object subject, Point area, IScrollBar hori, IScrollBar vert, Rectangle selectionRectangle, List<AreaOwner> areaOwners, int iconSize, int lineWidth, int gridSize, String noteFontName, int noteFontHeight, double zoomFactor, boolean drawingEditIcons) {
        this.gc = gc;
        this.variables = variables;
        this.subject = subject;
        this.area = area;
        this.hori = hori;
        this.vert = vert;
        this.selectionRectangle = selectionRectangle;
        this.areaOwners = areaOwners;
        areaOwners.clear();
        this.iconSize = iconSize;
        this.miniIconSize = iconSize / 2;
        this.lineWidth = lineWidth;
        this.gridSize = gridSize;
        this.magnification = 1.0f;
        this.zoomFactor = zoomFactor;
        this.drawingEditIcons = drawingEditIcons;
        gc.setAntialias(true);
        this.noteFontName = noteFontName;
        this.noteFontHeight = noteFontHeight;
    }

    public static IGc.EImage getStreamIconImage(StreamIcon streamIcon) {
        switch (streamIcon) {
            case TRUE: {
                return IGc.EImage.TRUE;
            }
            case FALSE: {
                return IGc.EImage.FALSE;
            }
            case ERROR: {
                return IGc.EImage.ERROR;
            }
            case INFO: {
                return IGc.EImage.INFO;
            }
            case TARGET: {
                return IGc.EImage.TARGET;
            }
            case INPUT: {
                return IGc.EImage.INPUT;
            }
            case OUTPUT: {
                return IGc.EImage.OUTPUT;
            }
        }
        return IGc.EImage.ARROW;
    }

    protected void drawNote(NotePadMeta notePadMeta) {
        Point ext;
        if (notePadMeta.isSelected()) {
            this.gc.setLineWidth(2);
        } else {
            this.gc.setLineWidth(1);
        }
        if (Utils.isEmpty((CharSequence)notePadMeta.getNote())) {
            ext = new Point(10, 10);
        } else {
            int fontHeight = notePadMeta.getFontSize() > 0 ? notePadMeta.getFontSize() : this.noteFontHeight;
            this.gc.setFont(Const.NVL((String)notePadMeta.getFontName(), (String)this.noteFontName), (int)((double)fontHeight / this.zoomFactor), notePadMeta.isFontBold(), notePadMeta.isFontItalic());
            ext = this.gc.textExtent(notePadMeta.getNote());
        }
        Point p = new Point(ext.x, ext.y);
        Point loc = notePadMeta.getLocation();
        Point note = this.real2screen(loc.x, loc.y);
        int margin = 5;
        p.x += 2 * margin;
        p.y += 2 * margin;
        int width = notePadMeta.width;
        int height = notePadMeta.height;
        if (p.x > width) {
            width = p.x;
        }
        if (p.y > height) {
            height = p.y;
        }
        Rectangle noteShape = new Rectangle(note.x, note.y, width, height);
        this.gc.setBackground(notePadMeta.getBackGroundColorRed(), notePadMeta.getBackGroundColorGreen(), notePadMeta.getBackGroundColorBlue());
        this.gc.setForeground(notePadMeta.getBorderColorRed(), notePadMeta.getBorderColorGreen(), notePadMeta.getBorderColorBlue());
        int radius = (int)Math.round(this.zoomFactor * (double)notePadMeta.getFontSize() / 2.0);
        this.gc.fillRoundRectangle(noteShape.x, noteShape.y, noteShape.width, noteShape.height, radius, radius);
        this.gc.drawRoundRectangle(noteShape.x, noteShape.y, noteShape.width, noteShape.height, radius, radius);
        if (!Utils.isEmpty((CharSequence)notePadMeta.getNote())) {
            this.gc.setForeground(notePadMeta.getFontColorRed(), notePadMeta.getFontColorGreen(), notePadMeta.getFontColorBlue());
            this.gc.drawText(notePadMeta.getNote(), note.x + margin, note.y + margin, true);
        }
        notePadMeta.width = width;
        notePadMeta.height = height;
        if (notePadMeta.isSelected()) {
            this.gc.setLineWidth(1);
        } else {
            this.gc.setLineWidth(2);
        }
        this.areaOwners.add(new AreaOwner<Object, NotePadMeta>(AreaOwner.AreaType.NOTE, noteShape.x, noteShape.y, noteShape.width, noteShape.height, this.offset, this.subject, notePadMeta));
    }

    protected int translateTo1To1(int value) {
        return Math.round((float)value / this.magnification);
    }

    protected int translateToCurrentScale(int value) {
        return Math.round((float)value * this.magnification);
    }

    protected Point real2screen(int x, int y) {
        Point screen = new Point(x + this.offset.x, y + this.offset.y);
        return screen;
    }

    protected Point getThumb(Point area, Point pipelineMax) {
        Point resizedMax = this.magnifyPoint(pipelineMax);
        Point thumb = new Point(0, 0);
        thumb.x = resizedMax.x <= area.x ? 100 : (int)Math.floor(100.0 * (double)area.x / (double)resizedMax.x);
        thumb.y = resizedMax.y <= area.y ? 100 : (int)Math.floor(100.0 * (double)area.y / (double)resizedMax.y);
        return thumb;
    }

    protected Point magnifyPoint(Point p) {
        return new Point(Math.round((float)p.x * this.magnification), Math.round((float)p.y * this.magnification));
    }

    protected Point getOffset(Point thumb, Point area) {
        Point p = new Point(0, 0);
        if (this.hori == null || this.vert == null) {
            return p;
        }
        Point sel = new Point(this.hori.getSelection(), this.vert.getSelection());
        if (thumb.x == 0 || thumb.y == 0) {
            return p;
        }
        p.x = Math.round((float)(-sel.x * area.x / thumb.x) / this.magnification);
        p.y = Math.round((float)(-sel.y * area.y / thumb.y) / this.magnification);
        return p;
    }

    protected void drawRect(Rectangle rect) {
        if (rect == null) {
            return;
        }
        this.gc.setLineStyle(IGc.ELineStyle.DASHDOT);
        this.gc.setLineWidth(this.lineWidth);
        this.gc.setForeground(IGc.EColor.GRAY);
        Point s = this.real2screen(rect.x, rect.y);
        if (rect.width < 0) {
            s.x += rect.width;
        }
        if (rect.height < 0) {
            s.y += rect.height;
        }
        this.gc.drawRectangle(s.x, s.y, Math.abs(rect.width), Math.abs(rect.height));
        this.gc.setLineStyle(IGc.ELineStyle.SOLID);
    }

    protected void drawGrid() {
        Point bounds = this.gc.getDeviceBounds();
        for (int x = 0; x < bounds.x; x += this.gridSize) {
            for (int y = 0; y < bounds.y; y += this.gridSize) {
                this.gc.drawPoint(x + this.offset.x % this.gridSize, y + this.offset.y % this.gridSize);
            }
        }
    }

    protected int calcArrowLength() {
        return 19 + (this.lineWidth - 1) * 5;
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public Point getArea() {
        return this.area;
    }

    public void setArea(Point area) {
        this.area = area;
    }

    public IScrollBar getHori() {
        return this.hori;
    }

    public void setHori(IScrollBar hori) {
        this.hori = hori;
    }

    public IScrollBar getVert() {
        return this.vert;
    }

    public void setVert(IScrollBar vert) {
        this.vert = vert;
    }

    public List<AreaOwner> getAreaOwners() {
        return this.areaOwners;
    }

    public void setAreaOwners(List<AreaOwner> areaOwners) {
        this.areaOwners = areaOwners;
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point offset) {
        this.offset = offset;
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int iconSize) {
        this.iconSize = iconSize;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public Rectangle getSelectionRectangle() {
        return this.selectionRectangle;
    }

    public void setSelectionRectangle(Rectangle selectionRectangle) {
        this.selectionRectangle = selectionRectangle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public float getTranslationX() {
        return this.translationX;
    }

    public void setTranslationX(float translationX) {
        this.translationX = translationX;
    }

    public float getTranslationY() {
        return this.translationY;
    }

    public void setTranslationY(float translationY) {
        this.translationY = translationY;
    }

    public Object getSubject() {
        return this.subject;
    }

    public void setSubject(Object subject) {
        this.subject = subject;
    }

    public IGc getGc() {
        return this.gc;
    }

    public void setGc(IGc gc) {
        this.gc = gc;
    }

    public String getNoteFontName() {
        return this.noteFontName;
    }

    public void setNoteFontName(String noteFontName) {
        this.noteFontName = noteFontName;
    }

    public int getNoteFontHeight() {
        return this.noteFontHeight;
    }

    public void setNoteFontHeight(int noteFontHeight) {
        this.noteFontHeight = noteFontHeight;
    }

    public double getTheta() {
        return this.theta;
    }

    public Hop getCandidate() {
        return this.candidate;
    }

    public void setCandidate(Hop candidate) {
        this.candidate = candidate;
    }

    protected int[] getLine(Part fs, Part ts) {
        if (fs == null || ts == null) {
            return null;
        }
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        int x1 = from.x + this.iconSize / 2;
        int y1 = from.y + this.iconSize / 2;
        int x2 = to.x + this.iconSize / 2;
        int y2 = to.y + this.iconSize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    protected void drawArrow(IGc.EImage arrow, int[] line, Hop hop, Object startObject, Object endObject) throws HopException {
        Point screenFrom = this.real2screen(line[0], line[1]);
        Point screenTo = this.real2screen(line[2], line[3]);
        this.drawArrow(arrow, screenFrom.x, screenFrom.y, screenTo.x, screenTo.y, this.theta, this.calcArrowLength(), -1.0, hop, startObject, endObject);
    }

    protected abstract void drawArrow(IGc.EImage var1, int var2, int var3, int var4, int var5, double var6, int var8, double var9, Hop var11, Object var12, Object var13) throws HopException;

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public boolean isDrawingEditIcons() {
        return this.drawingEditIcons;
    }

    public void setDrawingEditIcons(boolean drawingEditIcons) {
        this.drawingEditIcons = drawingEditIcons;
    }

    public int getMiniIconSize() {
        return this.miniIconSize;
    }

    public void setMiniIconSize(int miniIconSize) {
        this.miniIconSize = miniIconSize;
    }
}

