/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.config.DescribedVariable;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HopVariablesList {
    private static HopVariablesList instance;
    private List<DescribedVariable> defaultVariables = new ArrayList<DescribedVariable>();

    private HopVariablesList() {
    }

    public static HopVariablesList getInstance() {
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init() throws HopException {
        instance = new HopVariablesList();
        InputStream inputStream = null;
        try {
            HopVariablesList variablesList = HopVariablesList.getInstance();
            inputStream = variablesList.getClass().getResourceAsStream("hop-variables.xml");
            if (inputStream == null) {
                inputStream = variablesList.getClass().getResourceAsStream("/hop-variables.xml");
            }
            if (inputStream == null) {
                throw new HopPluginException("Unable to find standard hop variables definition file: hop-variables.xml");
            }
            Document doc = XmlHandler.loadXmlFile((InputStream)inputStream, null, (boolean)false, (boolean)false);
            Node varsNode = XmlHandler.getSubNode((Node)doc, (String)"hop-variables");
            int nrVars = XmlHandler.countNodes((Node)varsNode, (String)"hop-variable");
            for (int i = 0; i < nrVars; ++i) {
                Node varNode = XmlHandler.getSubNodeByNr((Node)varsNode, (String)"hop-variable", (int)i);
                String description = XmlHandler.getTagValue((Node)varNode, (String)"description");
                String variable = XmlHandler.getTagValue((Node)varNode, (String)"variable");
                String defaultValue = XmlHandler.getTagValue((Node)varNode, (String)"default-value");
                HopVariablesList.instance.defaultVariables.add(new DescribedVariable(variable, defaultValue, description));
            }
            if (inputStream == null) return;
        }
        catch (Exception e) {
            try {
                throw new HopException("Unable to read file 'hop-variables.xml'", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LogChannel.GENERAL.logDetailed("Unable to close file hop variables definition file", new Object[]{e2});
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException e) {
            LogChannel.GENERAL.logDetailed("Unable to close file hop variables definition file", new Object[]{e});
            return;
        }
    }

    public DescribedVariable findEnvironmentVariable(String name) {
        for (DescribedVariable describedVariable : this.defaultVariables) {
            if (!describedVariable.getName().equals(name)) continue;
            return describedVariable;
        }
        return null;
    }

    public Set<String> getVariablesSet() {
        HashSet<String> variablesSet = new HashSet<String>();
        for (DescribedVariable describedVariable : this.defaultVariables) {
            variablesSet.add(describedVariable.getName());
        }
        return variablesSet;
    }

    public List<DescribedVariable> getEnvironmentVariables() {
        return this.defaultVariables;
    }

    public void setDefaultVariables(List<DescribedVariable> defaultVariables) {
        this.defaultVariables = defaultVariables;
    }
}

