/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.config;

import org.apache.hop.core.config.DescribedVariable;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import picocli.CommandLine;

@ConfigPlugin(id="SetHopConfigVariables", description="Set system properties")
public class SetHopConfigVariables
implements IConfigOptions {
    @CommandLine.Option(names={"-sv", "--set-variable"}, description={"Set a variable, use format VAR=Value"})
    private String setVariable = null;
    @CommandLine.Option(names={"-dv", "--describe-variable"}, description={"Describe a variable, use format VARIABLE=Description"})
    private String describeVariable = null;

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        DescribedVariable describedVariable;
        String name;
        int equalsIndex;
        boolean changed = false;
        if (this.setVariable != null) {
            equalsIndex = this.setVariable.indexOf(61);
            if (equalsIndex > 0) {
                name = this.setVariable.substring(0, equalsIndex);
                String value = this.setVariable.substring(equalsIndex + 1);
                describedVariable = HopConfig.getInstance().findDescribedVariable(name);
                if (describedVariable == null) {
                    describedVariable = new DescribedVariable(name, value, null);
                } else {
                    describedVariable.setValue(value);
                }
                HopConfig.getInstance().setDescribedVariable(describedVariable);
                changed = true;
            } else {
                throw new HopException("Please set a variable value in the format 'VARIABLE_NAME=VALUE'");
            }
        }
        if (this.describeVariable != null) {
            equalsIndex = this.describeVariable.indexOf(61);
            if (equalsIndex > 0) {
                name = this.describeVariable.substring(0, equalsIndex);
                String description = this.describeVariable.substring(equalsIndex + 1);
                describedVariable = HopConfig.getInstance().findDescribedVariable(name);
                if (describedVariable == null) {
                    describedVariable = new DescribedVariable(name, null, description);
                } else {
                    describedVariable.setDescription(description);
                }
                HopConfig.getInstance().setDescribedVariable(describedVariable);
            } else {
                throw new HopException("Please set a variable description in the format 'VARIABLE_NAME=DESCRIPTION'");
            }
        }
        return false;
    }
}

