/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.base;

import java.util.Arrays;

public class CommandExecutorCodes {

    public static enum Kitchen {
        SUCCESS(0, "The workflow ran without a problem"),
        ERRORS_DURING_PROCESSING(1, "Errors occurred during processing"),
        UNEXPECTED_ERROR(2, "An unexpected error occurred during loading or running of the workflow"),
        HOP_VERSION_PRINT(6, "Hop Version printing"),
        COULD_NOT_LOAD_JOB(7, "The workflow couldn't be de-serialized"),
        ERROR_LOADING_TRANSFORMS_PLUGINS(8, "Error loading transforms or plugins (error in loading one of the plugins mostly)"),
        CMD_LINE_PRINT(9, "Command line usage printing");

        private int code;
        private String description;

        private Kitchen(int code, String description) {
            this.setCode(code);
            this.setDescription(description);
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public static Kitchen getByCode(int code) {
            return Arrays.asList(Kitchen.values()).stream().filter(kitchen -> kitchen.getCode() == code).findAny().orElse(null);
        }

        public static boolean isFailedExecution(int code) {
            return UNEXPECTED_ERROR.getCode() == code || COULD_NOT_LOAD_JOB.getCode() == code || ERROR_LOADING_TRANSFORMS_PLUGINS.getCode() == code;
        }
    }

    public static enum Pan {
        SUCCESS(0, "The pipeline ran without a problem"),
        ERRORS_DURING_PROCESSING(1, "Errors occurred during processing"),
        UNEXPECTED_ERROR(2, "An unexpected error occurred during loading / running of the pipeline"),
        UNABLE_TO_PREP_INIT_PIPELINE(3, "Unable to prepare and initialize this pipeline"),
        HOP_VERSION_PRINT(6, "Hop Version printing"),
        COULD_NOT_LOAD_PIPELINE(7, "The pipeline couldn't be de-serialized"),
        ERROR_LOADING_TRANSFORMS_PLUGINS(8, "Error loading transforms or plugins (error in loading one of the plugins mostly)"),
        CMD_LINE_PRINT(9, "Command line usage printing");

        private int code;
        private String description;

        private Pan(int code, String description) {
            this.setCode(code);
            this.setDescription(description);
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public static Pan getByCode(int code) {
            return Arrays.asList(Pan.values()).stream().filter(pan -> pan.getCode() == code).findAny().orElse(null);
        }

        public static boolean isFailedExecution(int code) {
            return UNEXPECTED_ERROR.getCode() == code || UNABLE_TO_PREP_INIT_PIPELINE.getCode() == code || COULD_NOT_LOAD_PIPELINE.getCode() == code || ERROR_LOADING_TRANSFORMS_PLUGINS.getCode() == code;
        }
    }
}

