/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.sqlbase;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="SQLBASE", typeDescription="Gupta SQL Base")
@GuiPlugin(id="GUI-SQLBaseDatabaseMeta")
public class GuptaDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 2155;
        }
        return -1;
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public String getDriverClass() {
        return "jdbc.gupta.sqlbase.SqlbaseDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:sqlbase://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsCatalogs() {
        return false;
    }

    public boolean supportsTimeStampToDateConversion() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        String retval = "";
        retval = retval + "ALTER TABLE " + tableName + " DROP " + v.getName() + Const.CR + ";" + Const.CR;
        retval = retval + "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
        return retval;
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "DATETIME NULL";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "INTEGER NOT NULL";
                    break;
                }
                if (length < 0 && precision < 0 || precision > 0 || length > 9) {
                    retval = retval + "DOUBLE PRECISION";
                    break;
                }
                retval = retval + "INTEGER";
                break;
            }
            case 2: {
                if (length > 254 || length < 0) {
                    retval = retval + "LONG VARCHAR";
                    break;
                }
                retval = retval + "VARCHAR(" + length + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public boolean isSystemTable(String tableName) {
        return tableName.startsWith("SYS");
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }
}

